/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray;

import java.lang.reflect.Array;
import org.tensorflow.ndarray.BooleanNdArray;
import org.tensorflow.ndarray.ByteNdArray;
import org.tensorflow.ndarray.DoubleNdArray;
import org.tensorflow.ndarray.FloatNdArray;
import org.tensorflow.ndarray.IntNdArray;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.ShortNdArray;
import org.tensorflow.ndarray.buffer.DataBuffers;

public final class StdArrays {
    public static IntNdArray ndCopyOf(int[] array) {
        IntNdArray ndArray = NdArrays.ofInts(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static IntNdArray ndCopyOf(int[][] array) {
        IntNdArray ndArray = NdArrays.ofInts(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static IntNdArray ndCopyOf(int[][][] array) {
        IntNdArray ndArray = NdArrays.ofInts(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static IntNdArray ndCopyOf(int[][][][] array) {
        IntNdArray ndArray = NdArrays.ofInts(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static IntNdArray ndCopyOf(int[][][][][] array) {
        IntNdArray ndArray = NdArrays.ofInts(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static IntNdArray ndCopyOf(int[][][][][][] array) {
        IntNdArray ndArray = NdArrays.ofInts(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static LongNdArray ndCopyOf(long[] array) {
        LongNdArray ndArray = NdArrays.ofLongs(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static LongNdArray ndCopyOf(long[][] array) {
        LongNdArray ndArray = NdArrays.ofLongs(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static LongNdArray ndCopyOf(long[][][] array) {
        LongNdArray ndArray = NdArrays.ofLongs(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static LongNdArray ndCopyOf(long[][][][] array) {
        LongNdArray ndArray = NdArrays.ofLongs(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static LongNdArray ndCopyOf(long[][][][][] array) {
        LongNdArray ndArray = NdArrays.ofLongs(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static LongNdArray ndCopyOf(long[][][][][][] array) {
        LongNdArray ndArray = NdArrays.ofLongs(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static FloatNdArray ndCopyOf(float[] array) {
        FloatNdArray ndArray = NdArrays.ofFloats(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static FloatNdArray ndCopyOf(float[][] array) {
        FloatNdArray ndArray = NdArrays.ofFloats(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static FloatNdArray ndCopyOf(float[][][] array) {
        FloatNdArray ndArray = NdArrays.ofFloats(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static FloatNdArray ndCopyOf(float[][][][] array) {
        FloatNdArray ndArray = NdArrays.ofFloats(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static FloatNdArray ndCopyOf(float[][][][][] array) {
        FloatNdArray ndArray = NdArrays.ofFloats(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static FloatNdArray ndCopyOf(float[][][][][][] array) {
        FloatNdArray ndArray = NdArrays.ofFloats(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static DoubleNdArray ndCopyOf(double[] array) {
        DoubleNdArray ndArray = NdArrays.ofDoubles(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static DoubleNdArray ndCopyOf(double[][] array) {
        DoubleNdArray ndArray = NdArrays.ofDoubles(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static DoubleNdArray ndCopyOf(double[][][] array) {
        DoubleNdArray ndArray = NdArrays.ofDoubles(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static DoubleNdArray ndCopyOf(double[][][][] array) {
        DoubleNdArray ndArray = NdArrays.ofDoubles(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static DoubleNdArray ndCopyOf(double[][][][][] array) {
        DoubleNdArray ndArray = NdArrays.ofDoubles(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static DoubleNdArray ndCopyOf(double[][][][][][] array) {
        DoubleNdArray ndArray = NdArrays.ofDoubles(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static ByteNdArray ndCopyOf(byte[] array) {
        ByteNdArray ndArray = NdArrays.ofBytes(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static ByteNdArray ndCopyOf(byte[][] array) {
        ByteNdArray ndArray = NdArrays.ofBytes(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static ByteNdArray ndCopyOf(byte[][][] array) {
        ByteNdArray ndArray = NdArrays.ofBytes(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static ByteNdArray ndCopyOf(byte[][][][] array) {
        ByteNdArray ndArray = NdArrays.ofBytes(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static ByteNdArray ndCopyOf(byte[][][][][] array) {
        ByteNdArray ndArray = NdArrays.ofBytes(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static ByteNdArray ndCopyOf(byte[][][][][][] array) {
        ByteNdArray ndArray = NdArrays.ofBytes(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static ShortNdArray ndCopyOf(short[] array) {
        ShortNdArray ndArray = NdArrays.ofShorts(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static ShortNdArray ndCopyOf(short[][] array) {
        ShortNdArray ndArray = NdArrays.ofShorts(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static ShortNdArray ndCopyOf(short[][][] array) {
        ShortNdArray ndArray = NdArrays.ofShorts(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static ShortNdArray ndCopyOf(short[][][][] array) {
        ShortNdArray ndArray = NdArrays.ofShorts(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static ShortNdArray ndCopyOf(short[][][][][] array) {
        ShortNdArray ndArray = NdArrays.ofShorts(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static ShortNdArray ndCopyOf(short[][][][][][] array) {
        ShortNdArray ndArray = NdArrays.ofShorts(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static BooleanNdArray ndCopyOf(boolean[] array) {
        BooleanNdArray ndArray = NdArrays.ofBooleans(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static BooleanNdArray ndCopyOf(boolean[][] array) {
        BooleanNdArray ndArray = NdArrays.ofBooleans(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static BooleanNdArray ndCopyOf(boolean[][][] array) {
        BooleanNdArray ndArray = NdArrays.ofBooleans(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static BooleanNdArray ndCopyOf(boolean[][][][] array) {
        BooleanNdArray ndArray = NdArrays.ofBooleans(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static BooleanNdArray ndCopyOf(boolean[][][][][] array) {
        BooleanNdArray ndArray = NdArrays.ofBooleans(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static BooleanNdArray ndCopyOf(boolean[][][][][][] array) {
        BooleanNdArray ndArray = NdArrays.ofBooleans(StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static <T> NdArray<T> ndCopyOf(T[] array) {
        NdArray<T> ndArray = NdArrays.ofObjects(StdArrays.componentTypeOf(array), StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static <T> NdArray<T> ndCopyOf(T[][] array) {
        NdArray<T> ndArray = NdArrays.ofObjects(StdArrays.componentTypeOf(array), StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static <T> NdArray<T> ndCopyOf(T[][][] array) {
        NdArray<T> ndArray = NdArrays.ofObjects(StdArrays.componentTypeOf(array), StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static <T> NdArray<T> ndCopyOf(T[][][][] array) {
        NdArray<T> ndArray = NdArrays.ofObjects(StdArrays.componentTypeOf(array), StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static <T> NdArray<T> ndCopyOf(T[][][][][] array) {
        NdArray<T> ndArray = NdArrays.ofObjects(StdArrays.componentTypeOf(array), StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static <T> NdArray<T> ndCopyOf(T[][][][][][] array) {
        NdArray<T> ndArray = NdArrays.ofObjects(StdArrays.componentTypeOf(array), StdArrays.shapeOf(array));
        StdArrays.copyTo(array, ndArray);
        return ndArray;
    }

    public static int[] array1dCopyOf(IntNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 1);
        int[] array = new int[dims[0]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static int[][] array2dCopyOf(IntNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 2);
        int[][] array = new int[dims[0]][dims[1]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static int[][][] array3dCopyOf(IntNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 3);
        int[][][] array = new int[dims[0]][dims[1]][dims[2]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static int[][][][] array4dCopyOf(IntNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 4);
        int[][][][] array = new int[dims[0]][dims[1]][dims[2]][dims[3]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static int[][][][][] array5dCopyOf(IntNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 5);
        int[][][][][] array = new int[dims[0]][dims[1]][dims[2]][dims[3]][dims[4]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static int[][][][][][] array6dCopyOf(IntNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 6);
        int[][][][][][] array = new int[dims[0]][dims[1]][dims[2]][dims[3]][dims[4]][dims[5]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static long[] array1dCopyOf(LongNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 1);
        long[] array = new long[dims[0]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static long[][] array2dCopyOf(LongNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 2);
        long[][] array = new long[dims[0]][dims[1]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static long[][][] array3dCopyOf(LongNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 3);
        long[][][] array = new long[dims[0]][dims[1]][dims[2]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static long[][][][] array4dCopyOf(LongNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 4);
        long[][][][] array = new long[dims[0]][dims[1]][dims[2]][dims[3]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static long[][][][][] array5dCopyOf(LongNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 5);
        long[][][][][] array = new long[dims[0]][dims[1]][dims[2]][dims[3]][dims[4]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static long[][][][][][] array6dCopyOf(LongNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 6);
        long[][][][][][] array = new long[dims[0]][dims[1]][dims[2]][dims[3]][dims[4]][dims[5]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static float[] array1dCopyOf(FloatNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 1);
        float[] array = new float[dims[0]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static float[][] array2dCopyOf(FloatNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 2);
        float[][] array = new float[dims[0]][dims[1]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static float[][][] array3dCopyOf(FloatNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 3);
        float[][][] array = new float[dims[0]][dims[1]][dims[2]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static float[][][][] array4dCopyOf(FloatNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 4);
        float[][][][] array = new float[dims[0]][dims[1]][dims[2]][dims[3]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static float[][][][][] array5dCopyOf(FloatNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 5);
        float[][][][][] array = new float[dims[0]][dims[1]][dims[2]][dims[3]][dims[4]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static float[][][][][][] array6dCopyOf(FloatNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 6);
        float[][][][][][] array = new float[dims[0]][dims[1]][dims[2]][dims[3]][dims[4]][dims[5]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static double[] array1dCopyOf(DoubleNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 1);
        double[] array = new double[dims[0]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static double[][] array2dCopyOf(DoubleNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 2);
        double[][] array = new double[dims[0]][dims[1]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static double[][][] array3dCopyOf(DoubleNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 3);
        double[][][] array = new double[dims[0]][dims[1]][dims[2]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static double[][][][] array4dCopyOf(DoubleNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 4);
        double[][][][] array = new double[dims[0]][dims[1]][dims[2]][dims[3]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static double[][][][][] array5dCopyOf(DoubleNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 5);
        double[][][][][] array = new double[dims[0]][dims[1]][dims[2]][dims[3]][dims[4]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static double[][][][][][] array6dCopyOf(DoubleNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 6);
        double[][][][][][] array = new double[dims[0]][dims[1]][dims[2]][dims[3]][dims[4]][dims[5]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static byte[] array1dCopyOf(ByteNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 1);
        byte[] array = new byte[dims[0]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static byte[][] array2dCopyOf(ByteNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 2);
        byte[][] array = new byte[dims[0]][dims[1]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static byte[][][] array3dCopyOf(ByteNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 3);
        byte[][][] array = new byte[dims[0]][dims[1]][dims[2]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static byte[][][][] array4dCopyOf(ByteNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 4);
        byte[][][][] array = new byte[dims[0]][dims[1]][dims[2]][dims[3]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static byte[][][][][] array5dCopyOf(ByteNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 5);
        byte[][][][][] array = new byte[dims[0]][dims[1]][dims[2]][dims[3]][dims[4]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static byte[][][][][][] array6dCopyOf(ByteNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 6);
        byte[][][][][][] array = new byte[dims[0]][dims[1]][dims[2]][dims[3]][dims[4]][dims[5]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static short[] array1dCopyOf(ShortNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 1);
        short[] array = new short[dims[0]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static short[][] array2dCopyOf(ShortNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 2);
        short[][] array = new short[dims[0]][dims[1]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static short[][][] array3dCopyOf(ShortNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 3);
        short[][][] array = new short[dims[0]][dims[1]][dims[2]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static short[][][][] array4dCopyOf(ShortNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 4);
        short[][][][] array = new short[dims[0]][dims[1]][dims[2]][dims[3]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static short[][][][][] array5dCopyOf(ShortNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 5);
        short[][][][][] array = new short[dims[0]][dims[1]][dims[2]][dims[3]][dims[4]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static short[][][][][][] array6dCopyOf(ShortNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 6);
        short[][][][][][] array = new short[dims[0]][dims[1]][dims[2]][dims[3]][dims[4]][dims[5]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static boolean[] array1dCopyOf(BooleanNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 1);
        boolean[] array = new boolean[dims[0]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static boolean[][] array2dCopyOf(BooleanNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 2);
        boolean[][] array = new boolean[dims[0]][dims[1]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static boolean[][][] array3dCopyOf(BooleanNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 3);
        boolean[][][] array = new boolean[dims[0]][dims[1]][dims[2]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static boolean[][][][] array4dCopyOf(BooleanNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 4);
        boolean[][][][] array = new boolean[dims[0]][dims[1]][dims[2]][dims[3]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static boolean[][][][][] array5dCopyOf(BooleanNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 5);
        boolean[][][][][] array = new boolean[dims[0]][dims[1]][dims[2]][dims[3]][dims[4]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static boolean[][][][][][] array6dCopyOf(BooleanNdArray ndArray) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 6);
        boolean[][][][][][] array = new boolean[dims[0]][dims[1]][dims[2]][dims[3]][dims[4]][dims[5]];
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static <T> T[] array1dCopyOf(NdArray<T> ndArray, Class<T> objectType) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 1);
        Object[] array = (Object[])Array.newInstance(objectType, dims[0]);
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static <T> T[][] array2dCopyOf(NdArray<T> ndArray, Class<T> objectType) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 2);
        Object[][] array = (Object[][])Array.newInstance(objectType, dims[0], dims[1]);
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static <T> T[][][] array3dCopyOf(NdArray<T> ndArray, Class<T> objectType) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 3);
        Object[][][] array = (Object[][][])Array.newInstance(objectType, dims[0], dims[1], dims[2]);
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static <T> T[][][][] array4dCopyOf(NdArray<T> ndArray, Class<T> objectType) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 4);
        Object[][][][] array = (Object[][][][])Array.newInstance(objectType, dims[0], dims[1], dims[2], dims[3]);
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static <T> T[][][][][] array5dCopyOf(NdArray<T> ndArray, Class<T> objectType) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 5);
        Object[][][][][] array = (Object[][][][][])Array.newInstance(objectType, dims[0], dims[1], dims[2], dims[3], dims[4]);
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static <T> T[][][][][][] array6dCopyOf(NdArray<T> ndArray, Class<T> objectType) {
        int[] dims = StdArrays.computeArrayDims(ndArray, 6);
        Object[][][][][][] array = (Object[][][][][][])Array.newInstance(objectType, dims[0], dims[1], dims[2], dims[3], dims[4], dims[5]);
        StdArrays.copyFrom(ndArray, array);
        return array;
    }

    public static void copyTo(int[] src, IntNdArray dst) {
        NdArrays.vectorOf(src).copyTo((NdArray)dst);
    }

    public static void copyTo(int[][] src, IntNdArray dst) {
        dst.elements(0).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]]).copyTo((NdArray)e));
    }

    public static void copyTo(int[][][] src, IntNdArray dst) {
        dst.elements(1).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]]).copyTo((NdArray)e));
    }

    public static void copyTo(int[][][][] src, IntNdArray dst) {
        dst.elements(2).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]][(int)idx[2]]).copyTo((NdArray)e));
    }

    public static void copyTo(int[][][][][] src, IntNdArray dst) {
        dst.elements(3).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]).copyTo((NdArray)e));
    }

    public static void copyTo(int[][][][][][] src, IntNdArray dst) {
        dst.elements(4).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]).copyTo((NdArray)e));
    }

    public static void copyTo(long[] src, LongNdArray dst) {
        NdArrays.vectorOf(src).copyTo((NdArray)dst);
    }

    public static void copyTo(long[][] src, LongNdArray dst) {
        dst.elements(0).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]]).copyTo((NdArray)e));
    }

    public static void copyTo(long[][][] src, LongNdArray dst) {
        dst.elements(1).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]]).copyTo((NdArray)e));
    }

    public static void copyTo(long[][][][] src, LongNdArray dst) {
        dst.elements(2).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]][(int)idx[2]]).copyTo((NdArray)e));
    }

    public static void copyTo(long[][][][][] src, LongNdArray dst) {
        dst.elements(3).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]).copyTo((NdArray)e));
    }

    public static void copyTo(long[][][][][][] src, LongNdArray dst) {
        dst.elements(4).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]).copyTo((NdArray)e));
    }

    public static void copyTo(float[] src, FloatNdArray dst) {
        NdArrays.vectorOf(src).copyTo((NdArray)dst);
    }

    public static void copyTo(float[][] src, FloatNdArray dst) {
        dst.elements(0).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]]).copyTo((NdArray)e));
    }

    public static void copyTo(float[][][] src, FloatNdArray dst) {
        dst.elements(1).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]]).copyTo((NdArray)e));
    }

    public static void copyTo(float[][][][] src, FloatNdArray dst) {
        dst.elements(2).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]][(int)idx[2]]).copyTo((NdArray)e));
    }

    public static void copyTo(float[][][][][] src, FloatNdArray dst) {
        dst.elements(3).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]).copyTo((NdArray)e));
    }

    public static void copyTo(float[][][][][][] src, FloatNdArray dst) {
        dst.elements(4).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]).copyTo((NdArray)e));
    }

    public static void copyTo(double[] src, DoubleNdArray dst) {
        NdArrays.vectorOf(src).copyTo((NdArray)dst);
    }

    public static void copyTo(double[][] src, DoubleNdArray dst) {
        dst.elements(0).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]]).copyTo((NdArray)e));
    }

    public static void copyTo(double[][][] src, DoubleNdArray dst) {
        dst.elements(1).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]]).copyTo((NdArray)e));
    }

    public static void copyTo(double[][][][] src, DoubleNdArray dst) {
        dst.elements(2).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]][(int)idx[2]]).copyTo((NdArray)e));
    }

    public static void copyTo(double[][][][][] src, DoubleNdArray dst) {
        dst.elements(3).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]).copyTo((NdArray)e));
    }

    public static void copyTo(double[][][][][][] src, DoubleNdArray dst) {
        dst.elements(4).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]).copyTo((NdArray)e));
    }

    public static void copyTo(byte[] src, ByteNdArray dst) {
        NdArrays.vectorOf(src).copyTo((NdArray)dst);
    }

    public static void copyTo(byte[][] src, ByteNdArray dst) {
        dst.elements(0).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]]).copyTo((NdArray)e));
    }

    public static void copyTo(byte[][][] src, ByteNdArray dst) {
        dst.elements(1).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]]).copyTo((NdArray)e));
    }

    public static void copyTo(byte[][][][] src, ByteNdArray dst) {
        dst.elements(2).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]][(int)idx[2]]).copyTo((NdArray)e));
    }

    public static void copyTo(byte[][][][][] src, ByteNdArray dst) {
        dst.elements(3).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]).copyTo((NdArray)e));
    }

    public static void copyTo(byte[][][][][][] src, ByteNdArray dst) {
        dst.elements(4).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]).copyTo((NdArray)e));
    }

    public static void copyTo(short[] src, ShortNdArray dst) {
        NdArrays.vectorOf(src).copyTo((NdArray)dst);
    }

    public static void copyTo(short[][] src, ShortNdArray dst) {
        dst.elements(0).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]]).copyTo((NdArray)e));
    }

    public static void copyTo(short[][][] src, ShortNdArray dst) {
        dst.elements(1).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]]).copyTo((NdArray)e));
    }

    public static void copyTo(short[][][][] src, ShortNdArray dst) {
        dst.elements(2).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]][(int)idx[2]]).copyTo((NdArray)e));
    }

    public static void copyTo(short[][][][][] src, ShortNdArray dst) {
        dst.elements(3).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]).copyTo((NdArray)e));
    }

    public static void copyTo(short[][][][][][] src, ShortNdArray dst) {
        dst.elements(4).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]).copyTo((NdArray)e));
    }

    public static void copyTo(boolean[] src, BooleanNdArray dst) {
        NdArrays.vectorOf(src).copyTo((NdArray)dst);
    }

    public static void copyTo(boolean[][] src, BooleanNdArray dst) {
        dst.elements(0).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]]).copyTo((NdArray)e));
    }

    public static void copyTo(boolean[][][] src, BooleanNdArray dst) {
        dst.elements(1).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]]).copyTo((NdArray)e));
    }

    public static void copyTo(boolean[][][][] src, BooleanNdArray dst) {
        dst.elements(2).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]][(int)idx[2]]).copyTo((NdArray)e));
    }

    public static void copyTo(boolean[][][][][] src, BooleanNdArray dst) {
        dst.elements(3).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]).copyTo((NdArray)e));
    }

    public static void copyTo(boolean[][][][][][] src, BooleanNdArray dst) {
        dst.elements(4).forEachIndexed((idx, e) -> NdArrays.vectorOf(src[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]).copyTo((NdArray)e));
    }

    public static <T> void copyTo(T[] src, NdArray<T> dst) {
        NdArrays.vectorOfObjects(src).copyTo(dst);
    }

    public static <T> void copyTo(T[][] src, NdArray<T> dst) {
        dst.elements(0).forEachIndexed((idx, e) -> NdArrays.vectorOfObjects(src[(int)idx[0]]).copyTo((NdArray<Object>)e));
    }

    public static <T> void copyTo(T[][][] src, NdArray<T> dst) {
        dst.elements(1).forEachIndexed((idx, e) -> NdArrays.vectorOfObjects(src[(int)idx[0]][(int)idx[1]]).copyTo((NdArray<Object>)e));
    }

    public static <T> void copyTo(T[][][][] src, NdArray<T> dst) {
        dst.elements(2).forEachIndexed((idx, e) -> NdArrays.vectorOfObjects(src[(int)idx[0]][(int)idx[1]][(int)idx[2]]).copyTo((NdArray<Object>)e));
    }

    public static <T> void copyTo(T[][][][][] src, NdArray<T> dst) {
        dst.elements(3).forEachIndexed((idx, e) -> NdArrays.vectorOfObjects(src[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]).copyTo((NdArray<Object>)e));
    }

    public static <T> void copyTo(T[][][][][][] src, NdArray<T> dst) {
        dst.elements(4).forEachIndexed((idx, e) -> NdArrays.vectorOfObjects(src[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]).copyTo((NdArray<Object>)e));
    }

    public static void copyFrom(IntNdArray src, int[] dst) {
        if (src.rank() != 1) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        if (src.size() > (long)dst.length) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(src.size()) + " > " + dst.length);
        }
        src.copyTo(DataBuffers.of(dst, false, false));
    }

    public static void copyFrom(IntNdArray src, int[][] dst) {
        if (src.rank() != 2) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(0).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]]));
    }

    public static void copyFrom(IntNdArray src, int[][][] dst) {
        if (src.rank() != 3) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(1).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]]));
    }

    public static void copyFrom(IntNdArray src, int[][][][] dst) {
        if (src.rank() != 4) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(2).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]]));
    }

    public static void copyFrom(IntNdArray src, int[][][][][] dst) {
        if (src.rank() != 5) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(3).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]));
    }

    public static void copyFrom(IntNdArray src, int[][][][][][] dst) {
        if (src.rank() != 6) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(4).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]));
    }

    public static void copyFrom(LongNdArray src, long[] dst) {
        if (src.rank() != 1) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        if (src.size() > (long)dst.length) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(src.size()) + " > " + dst.length);
        }
        src.copyTo(DataBuffers.of(dst, false, false));
    }

    public static void copyFrom(LongNdArray src, long[][] dst) {
        if (src.rank() != 2) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(0).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]]));
    }

    public static void copyFrom(LongNdArray src, long[][][] dst) {
        if (src.rank() != 3) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(1).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]]));
    }

    public static void copyFrom(LongNdArray src, long[][][][] dst) {
        if (src.rank() != 4) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(2).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]]));
    }

    public static void copyFrom(LongNdArray src, long[][][][][] dst) {
        if (src.rank() != 5) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(3).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]));
    }

    public static void copyFrom(LongNdArray src, long[][][][][][] dst) {
        if (src.rank() != 6) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(4).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]));
    }

    public static void copyFrom(FloatNdArray src, float[] dst) {
        if (src.rank() != 1) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        if (src.size() > (long)dst.length) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(src.size()) + " > " + dst.length);
        }
        src.copyTo(DataBuffers.of(dst, false, false));
    }

    public static void copyFrom(FloatNdArray src, float[][] dst) {
        if (src.rank() != 2) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(0).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]]));
    }

    public static void copyFrom(FloatNdArray src, float[][][] dst) {
        if (src.rank() != 3) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(1).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]]));
    }

    public static void copyFrom(FloatNdArray src, float[][][][] dst) {
        if (src.rank() != 4) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(2).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]]));
    }

    public static void copyFrom(FloatNdArray src, float[][][][][] dst) {
        if (src.rank() != 5) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(3).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]));
    }

    public static void copyFrom(FloatNdArray src, float[][][][][][] dst) {
        if (src.rank() != 6) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(4).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]));
    }

    public static void copyFrom(DoubleNdArray src, double[] dst) {
        if (src.rank() != 1) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        if (src.size() > (long)dst.length) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(src.size()) + " > " + dst.length);
        }
        src.copyTo(DataBuffers.of(dst, false, false));
    }

    public static void copyFrom(DoubleNdArray src, double[][] dst) {
        if (src.rank() != 2) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(0).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]]));
    }

    public static void copyFrom(DoubleNdArray src, double[][][] dst) {
        if (src.rank() != 3) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(1).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]]));
    }

    public static void copyFrom(DoubleNdArray src, double[][][][] dst) {
        if (src.rank() != 4) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(2).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]]));
    }

    public static void copyFrom(DoubleNdArray src, double[][][][][] dst) {
        if (src.rank() != 5) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(3).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]));
    }

    public static void copyFrom(DoubleNdArray src, double[][][][][][] dst) {
        if (src.rank() != 6) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(4).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]));
    }

    public static void copyFrom(ByteNdArray src, byte[] dst) {
        if (src.rank() != 1) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        if (src.size() > (long)dst.length) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(src.size()) + " > " + dst.length);
        }
        src.copyTo(DataBuffers.of(dst, false, false));
    }

    public static void copyFrom(ByteNdArray src, byte[][] dst) {
        if (src.rank() != 2) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(0).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]]));
    }

    public static void copyFrom(ByteNdArray src, byte[][][] dst) {
        if (src.rank() != 3) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(1).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]]));
    }

    public static void copyFrom(ByteNdArray src, byte[][][][] dst) {
        if (src.rank() != 4) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(2).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]]));
    }

    public static void copyFrom(ByteNdArray src, byte[][][][][] dst) {
        if (src.rank() != 5) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(3).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]));
    }

    public static void copyFrom(ByteNdArray src, byte[][][][][][] dst) {
        if (src.rank() != 6) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(4).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]));
    }

    public static void copyFrom(ShortNdArray src, short[] dst) {
        if (src.rank() != 1) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        if (src.size() > (long)dst.length) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(src.size()) + " > " + dst.length);
        }
        src.copyTo(DataBuffers.of(dst, false, false));
    }

    public static void copyFrom(ShortNdArray src, short[][] dst) {
        if (src.rank() != 2) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(0).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]]));
    }

    public static void copyFrom(ShortNdArray src, short[][][] dst) {
        if (src.rank() != 3) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(1).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]]));
    }

    public static void copyFrom(ShortNdArray src, short[][][][] dst) {
        if (src.rank() != 4) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(2).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]]));
    }

    public static void copyFrom(ShortNdArray src, short[][][][][] dst) {
        if (src.rank() != 5) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(3).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]));
    }

    public static void copyFrom(ShortNdArray src, short[][][][][][] dst) {
        if (src.rank() != 6) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(4).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]));
    }

    public static void copyFrom(BooleanNdArray src, boolean[] dst) {
        if (src.rank() != 1) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        if (src.size() > (long)dst.length) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(src.size()) + " > " + dst.length);
        }
        src.copyTo(DataBuffers.of(dst, false, false));
    }

    public static void copyFrom(BooleanNdArray src, boolean[][] dst) {
        if (src.rank() != 2) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(0).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]]));
    }

    public static void copyFrom(BooleanNdArray src, boolean[][][] dst) {
        if (src.rank() != 3) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(1).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]]));
    }

    public static void copyFrom(BooleanNdArray src, boolean[][][][] dst) {
        if (src.rank() != 4) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(2).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]]));
    }

    public static void copyFrom(BooleanNdArray src, boolean[][][][][] dst) {
        if (src.rank() != 5) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(3).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]));
    }

    public static void copyFrom(BooleanNdArray src, boolean[][][][][][] dst) {
        if (src.rank() != 6) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(4).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]));
    }

    public static <T> void copyFrom(NdArray<T> src, T[] dst) {
        if (src.rank() != 1) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        if (src.size() > (long)dst.length) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(src.size()) + " > " + dst.length);
        }
        src.copyTo(DataBuffers.of(dst, false, false));
    }

    public static <T> void copyFrom(NdArray<T> src, T[][] dst) {
        if (src.rank() != 2) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(0).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]]));
    }

    public static <T> void copyFrom(NdArray<T> src, T[][][] dst) {
        if (src.rank() != 3) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(1).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]]));
    }

    public static <T> void copyFrom(NdArray<T> src, T[][][][] dst) {
        if (src.rank() != 4) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(2).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]]));
    }

    public static <T> void copyFrom(NdArray<T> src, T[][][][][] dst) {
        if (src.rank() != 5) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(3).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]]));
    }

    public static <T> void copyFrom(NdArray<T> src, T[][][][][][] dst) {
        if (src.rank() != 6) {
            throw new IllegalArgumentException("Array cannot be copied from NdArray of rank " + src.rank());
        }
        src.elements(4).forEachIndexed((idx, e) -> StdArrays.copyFrom(e, dst[(int)idx[0]][(int)idx[1]][(int)idx[2]][(int)idx[3]][(int)idx[4]]));
    }

    public static Shape shapeOf(int[] array) {
        return Shape.of(array.length);
    }

    public static Shape shapeOf(int[][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[2]));
    }

    public static Shape shapeOf(int[][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[3]));
    }

    public static Shape shapeOf(int[][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[4]));
    }

    public static Shape shapeOf(int[][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[5]));
    }

    public static Shape shapeOf(int[][][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[6]));
    }

    public static Shape shapeOf(long[] array) {
        return Shape.of(array.length);
    }

    public static Shape shapeOf(long[][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[2]));
    }

    public static Shape shapeOf(long[][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[3]));
    }

    public static Shape shapeOf(long[][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[4]));
    }

    public static Shape shapeOf(long[][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[5]));
    }

    public static Shape shapeOf(long[][][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[6]));
    }

    public static Shape shapeOf(float[] array) {
        return Shape.of(array.length);
    }

    public static Shape shapeOf(float[][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[2]));
    }

    public static Shape shapeOf(float[][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[3]));
    }

    public static Shape shapeOf(float[][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[4]));
    }

    public static Shape shapeOf(float[][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[5]));
    }

    public static Shape shapeOf(float[][][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[6]));
    }

    public static Shape shapeOf(double[] array) {
        return Shape.of(array.length);
    }

    public static Shape shapeOf(double[][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[2]));
    }

    public static Shape shapeOf(double[][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[3]));
    }

    public static Shape shapeOf(double[][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[4]));
    }

    public static Shape shapeOf(double[][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[5]));
    }

    public static Shape shapeOf(double[][][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[6]));
    }

    public static Shape shapeOf(byte[] array) {
        return Shape.of(array.length);
    }

    public static Shape shapeOf(byte[][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[2]));
    }

    public static Shape shapeOf(byte[][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[3]));
    }

    public static Shape shapeOf(byte[][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[4]));
    }

    public static Shape shapeOf(byte[][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[5]));
    }

    public static Shape shapeOf(byte[][][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[6]));
    }

    public static Shape shapeOf(short[] array) {
        return Shape.of(array.length);
    }

    public static Shape shapeOf(short[][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[2]));
    }

    public static Shape shapeOf(short[][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[3]));
    }

    public static Shape shapeOf(short[][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[4]));
    }

    public static Shape shapeOf(short[][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[5]));
    }

    public static Shape shapeOf(short[][][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[6]));
    }

    public static Shape shapeOf(boolean[] array) {
        return Shape.of(array.length);
    }

    public static Shape shapeOf(boolean[][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[2]));
    }

    public static Shape shapeOf(boolean[][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[3]));
    }

    public static Shape shapeOf(boolean[][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[4]));
    }

    public static Shape shapeOf(boolean[][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[5]));
    }

    public static Shape shapeOf(boolean[][][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[6]));
    }

    public static <T> Shape shapeOf(T[] array) {
        return Shape.of(array.length);
    }

    public static <T> Shape shapeOf(T[][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[2]));
    }

    public static <T> Shape shapeOf(T[][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[3]));
    }

    public static <T> Shape shapeOf(T[][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[4]));
    }

    public static <T> Shape shapeOf(T[][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[5]));
    }

    public static <T> Shape shapeOf(T[][][][][][] array) {
        return Shape.of(StdArrays.computeShape(array, new long[6]));
    }

    private static void dimSize(int arrayLength, long[] shape, int dimIdx) {
        if (shape[dimIdx] == 0L) {
            shape[dimIdx] = arrayLength;
        } else if (shape[dimIdx] != (long)arrayLength) {
            shape[dimIdx] = Shape.UNKNOWN_SIZE;
        }
    }

    private static long[] computeShape(int[][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 2);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                throw new IllegalStateException("One of the subarray is null");
            }
            StdArrays.dimSize(array[i].length, shape, shape.length - 1);
        }
        return shape;
    }

    private static long[] computeShape(int[][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 3);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(int[][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 4);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(int[][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 5);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(int[][][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 6);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(long[][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 2);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                throw new IllegalStateException("One of the subarray is null");
            }
            StdArrays.dimSize(array[i].length, shape, shape.length - 1);
        }
        return shape;
    }

    private static long[] computeShape(long[][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 3);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(long[][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 4);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(long[][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 5);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(long[][][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 6);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(float[][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 2);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                throw new IllegalStateException("One of the subarray is null");
            }
            StdArrays.dimSize(array[i].length, shape, shape.length - 1);
        }
        return shape;
    }

    private static long[] computeShape(float[][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 3);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(float[][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 4);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(float[][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 5);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(float[][][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 6);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(double[][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 2);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                throw new IllegalStateException("One of the subarray is null");
            }
            StdArrays.dimSize(array[i].length, shape, shape.length - 1);
        }
        return shape;
    }

    private static long[] computeShape(double[][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 3);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(double[][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 4);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(double[][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 5);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(double[][][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 6);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(byte[][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 2);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                throw new IllegalStateException("One of the subarray is null");
            }
            StdArrays.dimSize(array[i].length, shape, shape.length - 1);
        }
        return shape;
    }

    private static long[] computeShape(byte[][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 3);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(byte[][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 4);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(byte[][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 5);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(byte[][][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 6);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(short[][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 2);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                throw new IllegalStateException("One of the subarray is null");
            }
            StdArrays.dimSize(array[i].length, shape, shape.length - 1);
        }
        return shape;
    }

    private static long[] computeShape(short[][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 3);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(short[][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 4);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(short[][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 5);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(short[][][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 6);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(boolean[][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 2);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                throw new IllegalStateException("One of the subarray is null");
            }
            StdArrays.dimSize(array[i].length, shape, shape.length - 1);
        }
        return shape;
    }

    private static long[] computeShape(boolean[][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 3);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(boolean[][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 4);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(boolean[][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 5);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static long[] computeShape(boolean[][][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 6);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static <T> long[] computeShape(T[][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 2);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                throw new IllegalStateException("One of the subarray is null");
            }
            StdArrays.dimSize(array[i].length, shape, shape.length - 1);
        }
        return shape;
    }

    private static <T> long[] computeShape(T[][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 3);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static <T> long[] computeShape(T[][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 4);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static <T> long[] computeShape(T[][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 5);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static <T> long[] computeShape(T[][][][][][] array, long[] shape) {
        if (array == null) {
            throw new IllegalStateException("The array or one of its subarray is null");
        }
        StdArrays.dimSize(array.length, shape, shape.length - 6);
        for (int i = 0; i < array.length; ++i) {
            StdArrays.computeShape(array[i], shape);
        }
        return shape;
    }

    private static <T> Class<T> componentTypeOf(Object array) {
        Class<?> componentType = array.getClass().getComponentType();
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
        }
        return componentType;
    }

    private static int[] computeArrayDims(NdArray<?> ndArray, int expectedRank) {
        Shape shape = ndArray.shape();
        if (shape.numDimensions() != expectedRank) {
            throw new IllegalArgumentException("NdArray must be of rank " + expectedRank);
        }
        int[] arrayShape = new int[expectedRank];
        for (int i = 0; i < expectedRank; ++i) {
            long dimSize = shape.get(i);
            if (dimSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Dimension " + i + " is too large to fit in a standard array (" + shape.get(i) + ")");
            }
            arrayShape[i] = (int)dimSize;
        }
        return arrayShape;
    }
}

