/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="ScaleAndTranslate", inputsClass=Inputs.class)
public final class ScaleAndTranslate
extends RawOp
implements Operand<TFloat32> {
    public static final String OP_NAME = "ScaleAndTranslate";
    private Output<TFloat32> resizedImages;

    public ScaleAndTranslate(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.resizedImages = operation.output(outputIdx++);
    }

    public static ScaleAndTranslate create(Scope scope, Operand<? extends TNumber> images, Operand<TInt32> sizeOutput, Operand<TFloat32> scale, Operand<TFloat32> translation, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(images.asOutput());
        opBuilder.addInput(sizeOutput.asOutput());
        opBuilder.addInput(scale.asOutput());
        opBuilder.addInput(translation.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.kernelType != null) {
                    opBuilder.setAttr("kernel_type", opts.kernelType);
                }
                if (opts.antialias == null) continue;
                opBuilder.setAttr("antialias", opts.antialias);
            }
        }
        return new ScaleAndTranslate(opBuilder.build());
    }

    public static Options kernelType(String kernelType) {
        return new Options().kernelType(kernelType);
    }

    public static Options antialias(Boolean antialias) {
        return new Options().antialias(antialias);
    }

    public Output<TFloat32> resizedImages() {
        return this.resizedImages;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.resizedImages;
    }

    @OpInputsMetadata(outputsClass=ScaleAndTranslate.class)
    public static class Inputs
    extends RawOpInputs<ScaleAndTranslate> {
        public final Operand<? extends TNumber> images;
        public final Operand<TInt32> sizeOutput;
        public final Operand<TFloat32> scale;
        public final Operand<TFloat32> translation;
        public final DataType T;
        public final String kernelType;
        public final boolean antialias;

        public Inputs(GraphOperation op) {
            super(new ScaleAndTranslate(op), op, Arrays.asList("T", "kernel_type", "antialias"));
            int inputIndex = 0;
            this.images = op.input(inputIndex++);
            this.sizeOutput = op.input(inputIndex++);
            this.scale = op.input(inputIndex++);
            this.translation = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.kernelType = op.attributes().getAttrString("kernel_type");
            this.antialias = op.attributes().getAttrBool("antialias");
        }
    }

    public static class Options {
        private String kernelType;
        private Boolean antialias;

        private Options() {
        }

        public Options kernelType(String kernelType) {
            this.kernelType = kernelType;
            return this;
        }

        public Options antialias(Boolean antialias) {
            this.antialias = antialias;
            return this;
        }
    }
}

