/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TemporaryVariable", inputsClass=Inputs.class)
public final class TemporaryVariable<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "TemporaryVariable";
    private Output<T> ref;

    public TemporaryVariable(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.ref = operation.output(outputIdx++);
    }

    public static <T extends TType> TemporaryVariable<T> create(Scope scope, Shape shape, Class<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.setAttr("shape", shape);
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.varName == null) continue;
                opBuilder.setAttr("var_name", opts.varName);
            }
        }
        return new TemporaryVariable<T>(opBuilder.build());
    }

    public static Options varName(String varName) {
        return new Options().varName(varName);
    }

    public Output<T> ref() {
        return this.ref;
    }

    @Override
    public Output<T> asOutput() {
        return this.ref;
    }

    @OpInputsMetadata(outputsClass=TemporaryVariable.class)
    public static class Inputs
    extends RawOpInputs<TemporaryVariable<?>> {
        public final Shape shape;
        public final DataType dtype;
        public final String varName;

        public Inputs(GraphOperation op) {
            super(new TemporaryVariable(op), op, Arrays.asList("shape", "dtype", "var_name"));
            boolean inputIndex = false;
            this.shape = op.attributes().getAttrShape("shape");
            this.dtype = op.attributes().getAttrType("dtype");
            this.varName = op.attributes().getAttrString("var_name");
        }
    }

    public static class Options {
        private String varName;

        private Options() {
        }

        public Options varName(String varName) {
            this.varName = varName;
            return this;
        }
    }
}

