/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data.experimental;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ExperimentalAutoShardDataset", inputsClass=Inputs.class)
public final class AutoShardDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "ExperimentalAutoShardDataset";
    private Output<? extends TType> handle;

    public AutoShardDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static AutoShardDataset create(Scope scope, Operand<? extends TType> inputDataset, Operand<TInt64> numWorkers, Operand<TInt64> index, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "AutoShardDataset");
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(numWorkers.asOutput());
        opBuilder.addInput(index.asOutput());
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.autoShardPolicy == null) continue;
                opBuilder.setAttr("auto_shard_policy", opts.autoShardPolicy);
            }
        }
        return new AutoShardDataset(opBuilder.build());
    }

    public static Options autoShardPolicy(Long autoShardPolicy) {
        return new Options().autoShardPolicy(autoShardPolicy);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=AutoShardDataset.class)
    public static class Inputs
    extends RawOpInputs<AutoShardDataset> {
        public final Operand<? extends TType> inputDataset;
        public final Operand<TInt64> numWorkers;
        public final Operand<TInt64> index;
        public final long autoShardPolicy;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;

        public Inputs(GraphOperation op) {
            super(new AutoShardDataset(op), op, Arrays.asList("auto_shard_policy", "output_types", "output_shapes"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            this.numWorkers = op.input(inputIndex++);
            this.index = op.input(inputIndex++);
            this.autoShardPolicy = op.attributes().getAttrInt("auto_shard_policy");
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
        }
    }

    public static class Options {
        private Long autoShardPolicy;

        private Options() {
        }

        public Options autoShardPolicy(Long autoShardPolicy) {
            this.autoShardPolicy = autoShardPolicy;
            return this;
        }
    }
}

