/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.buffer;

import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataBufferWindow;

public abstract class AbstractDataBufferWindow<B extends DataBuffer<?>>
implements DataBufferWindow<B> {
    private final B windowBuffer;
    private final long maxOffset;
    private long offset = 0L;

    @Override
    public final long offset() {
        return this.offset;
    }

    @Override
    public final long size() {
        return this.windowBuffer.size();
    }

    @Override
    public final DataBufferWindow<B> slideTo(long index) {
        if (index < 0L || index > this.maxOffset) {
            throw new IndexOutOfBoundsException();
        }
        this.offset(index);
        this.offset = index;
        return this;
    }

    @Override
    public final DataBufferWindow<B> slide(long step) {
        return this.slideTo(this.offset + step);
    }

    @Override
    public final B buffer() {
        return this.windowBuffer;
    }

    protected abstract void offset(long var1);

    protected AbstractDataBufferWindow(B windowBuffer, long bufferLimit) {
        this.windowBuffer = windowBuffer;
        this.maxOffset = bufferLimit - windowBuffer.size();
    }
}

