/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SparseFillEmptyRows", inputsClass=Inputs.class)
public final class SparseFillEmptyRows<T extends TType>
extends RawOp {
    public static final String OP_NAME = "SparseFillEmptyRows";
    private Output<TInt64> outputIndices;
    private Output<T> outputValues;
    private Output<TBool> emptyRowIndicator;
    private Output<TInt64> reverseIndexMap;

    public SparseFillEmptyRows(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.outputIndices = operation.output(outputIdx++);
        this.outputValues = operation.output(outputIdx++);
        this.emptyRowIndicator = operation.output(outputIdx++);
        this.reverseIndexMap = operation.output(outputIdx++);
    }

    public static <T extends TType> SparseFillEmptyRows<T> create(Scope scope, Operand<TInt64> indices, Operand<T> values, Operand<TInt64> denseShape, Operand<T> defaultValue) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(indices.asOutput());
        opBuilder.addInput(values.asOutput());
        opBuilder.addInput(denseShape.asOutput());
        opBuilder.addInput(defaultValue.asOutput());
        return new SparseFillEmptyRows<T>(opBuilder.build());
    }

    public Output<TInt64> outputIndices() {
        return this.outputIndices;
    }

    public Output<T> outputValues() {
        return this.outputValues;
    }

    public Output<TBool> emptyRowIndicator() {
        return this.emptyRowIndicator;
    }

    public Output<TInt64> reverseIndexMap() {
        return this.reverseIndexMap;
    }

    @OpInputsMetadata(outputsClass=SparseFillEmptyRows.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<SparseFillEmptyRows<T>> {
        public final Operand<TInt64> indices;
        public final Operand<T> values;
        public final Operand<TInt64> denseShape;
        public final Operand<T> defaultValue;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new SparseFillEmptyRows(op), op, Arrays.asList("T"));
            int inputIndex = 0;
            this.indices = op.input(inputIndex++);
            this.values = op.input(inputIndex++);
            this.denseShape = op.input(inputIndex++);
            this.defaultValue = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
        }
    }
}

