/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.random;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="StatefulRandomBinomial", inputsClass=Inputs.class)
public final class StatefulRandomBinomial<V extends TNumber>
extends RawOp
implements Operand<V> {
    public static final String OP_NAME = "StatefulRandomBinomial";
    private Output<V> output;

    public StatefulRandomBinomial(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <V extends TNumber, U extends TNumber> StatefulRandomBinomial<V> create(Scope scope, Operand<? extends TType> resource, Operand<TInt64> algorithm, Operand<? extends TNumber> shape, Operand<U> counts, Operand<U> probs, Class<V> dtype) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(resource.asOutput());
        opBuilder.addInput(algorithm.asOutput());
        opBuilder.addInput(shape.asOutput());
        opBuilder.addInput(counts.asOutput());
        opBuilder.addInput(probs.asOutput());
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        return new StatefulRandomBinomial<V>(opBuilder.build());
    }

    public static <U extends TNumber> StatefulRandomBinomial<TInt64> create(Scope scope, Operand<? extends TType> resource, Operand<TInt64> algorithm, Operand<? extends TNumber> shape, Operand<U> counts, Operand<U> probs) {
        return StatefulRandomBinomial.create(scope, resource, algorithm, shape, counts, probs, TInt64.class);
    }

    public Output<V> output() {
        return this.output;
    }

    @Override
    public Output<V> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=StatefulRandomBinomial.class)
    public static class Inputs<U extends TNumber>
    extends RawOpInputs<StatefulRandomBinomial<?>> {
        public final Operand<? extends TType> resource;
        public final Operand<TInt64> algorithm;
        public final Operand<? extends TNumber> shape;
        public final Operand<U> counts;
        public final Operand<U> probs;
        public final DataType S;
        public final DataType T;
        public final DataType dtype;

        public Inputs(GraphOperation op) {
            super(new StatefulRandomBinomial(op), op, Arrays.asList("S", "T", "dtype"));
            int inputIndex = 0;
            this.resource = op.input(inputIndex++);
            this.algorithm = op.input(inputIndex++);
            this.shape = op.input(inputIndex++);
            this.counts = op.input(inputIndex++);
            this.probs = op.input(inputIndex++);
            this.S = op.attributes().getAttrType("S");
            this.T = op.attributes().getAttrType("T");
            this.dtype = op.attributes().getAttrType("dtype");
        }
    }
}

