/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="QueueDequeueV2", inputsClass=Inputs.class)
public final class QueueDequeue
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "QueueDequeueV2";
    private List<Output<?>> components;

    public QueueDequeue(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int componentsLength = operation.outputListLength("components");
        this.components = Arrays.asList(operation.outputList(outputIdx, componentsLength));
        outputIdx += componentsLength;
    }

    public static QueueDequeue create(Scope scope, Operand<? extends TType> handle, List<Class<? extends TType>> componentTypes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "QueueDequeue");
        opBuilder.addInput(handle.asOutput());
        opBuilder.setAttr("component_types", Operands.toDataTypes(componentTypes));
        if (options != null) {
            for (Options opts : options) {
                if (opts.timeoutMs == null) continue;
                opBuilder.setAttr("timeout_ms", opts.timeoutMs);
            }
        }
        return new QueueDequeue(opBuilder.build());
    }

    public static Options timeoutMs(Long timeoutMs) {
        return new Options().timeoutMs(timeoutMs);
    }

    public List<Output<?>> components() {
        return this.components;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.components.iterator();
    }

    @OpInputsMetadata(outputsClass=QueueDequeue.class)
    public static class Inputs
    extends RawOpInputs<QueueDequeue> {
        public final Operand<? extends TType> handle;
        public final DataType[] componentTypes;
        public final long timeoutMs;

        public Inputs(GraphOperation op) {
            super(new QueueDequeue(op), op, Arrays.asList("component_types", "timeout_ms"));
            int inputIndex = 0;
            this.handle = op.input(inputIndex++);
            this.componentTypes = op.attributes().getAttrTypeList("component_types");
            this.timeoutMs = op.attributes().getAttrInt("timeout_ms");
        }
    }

    public static class Options {
        private Long timeoutMs;

        private Options() {
        }

        public Options timeoutMs(Long timeoutMs) {
            this.timeoutMs = timeoutMs;
            return this;
        }
    }
}

