/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.charset.StandardCharsets;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.PointerScope;
import org.bytedeco.javacpp.SizeTPointer;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.OperationAttributeInspector;
import org.tensorflow.RawTensor;
import org.tensorflow.Tensor;
import org.tensorflow.internal.c_api.TF_AttrMetadata;
import org.tensorflow.internal.c_api.TF_Buffer;
import org.tensorflow.internal.c_api.TF_Status;
import org.tensorflow.internal.c_api.TF_Tensor;
import org.tensorflow.internal.c_api.global.tensorflow;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.AttributeMetadata;
import org.tensorflow.proto.framework.AttrValue;
import org.tensorflow.proto.framework.DataType;

class GraphOperationAttributeInspector
implements OperationAttributeInspector {
    private final GraphOperation op;

    GraphOperationAttributeInspector(GraphOperation op) {
        this.op = op;
    }

    @Override
    public AttributeMetadata getAttrMetadata(String name) {
        try (PointerScope scope = new PointerScope();){
            TF_Status status = TF_Status.newStatus();
            TF_AttrMetadata r = tensorflow.TF_OperationGetAttrMetadata(this.op.getCheckedNativeHandle(), name, status);
            status.throwExceptionIfNotOK();
            AttributeMetadata attributeMetadata = new AttributeMetadata(r);
            return attributeMetadata;
        }
    }

    @Override
    public AttrValue getAttrValueProto(String name) {
        AttrValue attrValue;
        PointerScope scope = new PointerScope();
        try {
            TF_Buffer buffer = TF_Buffer.newBuffer();
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_OperationGetAttrValueProto(this.op.getCheckedNativeHandle(), name, buffer, status);
            status.throwExceptionIfNotOK();
            attrValue = AttrValue.parseFrom(buffer.dataAsByteBuffer());
        }
        catch (Throwable throwable) {
            try {
                try {
                    scope.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalStateException("Invalid protobuf for attribute " + name, e);
            }
        }
        scope.close();
        return attrValue;
    }

    @Override
    public String getAttrString(String name) {
        try (PointerScope scope = new PointerScope();){
            long size = this.getAttrMetadata((String)name).totalSize;
            BytePointer result = new BytePointer(size);
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_OperationGetAttrString(this.op.getCheckedNativeHandle(), name, (Pointer)result, size, status);
            status.throwExceptionIfNotOK();
            String string = result.getString();
            return string;
        }
    }

    @Override
    public String[] getAttrStringList(String name) {
        try (PointerScope scope = new PointerScope();){
            AttributeMetadata metadata = this.getAttrMetadata(name);
            int listSize = (int)metadata.listSize;
            long totalSize = metadata.totalSize;
            PointerPointer values = new PointerPointer((long)listSize);
            SizeTPointer lengths = new SizeTPointer((long)listSize);
            BytePointer storage = new BytePointer(totalSize);
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_OperationGetAttrStringList(this.op.getCheckedNativeHandle(), new BytePointer(name), values, lengths, listSize, (Pointer)storage, totalSize, status);
            status.throwExceptionIfNotOK();
            String[] results = new String[listSize];
            for (int i = 0; i < results.length; ++i) {
                int length = (int)lengths.get((long)i);
                if (length == 0) {
                    results[i] = "";
                    continue;
                }
                byte[] bytes = new byte[length];
                BytePointer p = (BytePointer)values.get(BytePointer.class, (long)i);
                p.get(bytes);
                results[i] = new String(bytes, StandardCharsets.UTF_8);
            }
            String[] stringArray = results;
            return stringArray;
        }
    }

    @Override
    public long getAttrInt(String name) {
        try (PointerScope scope = new PointerScope();){
            long[] result = new long[1];
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_OperationGetAttrInt(this.op.getCheckedNativeHandle(), name, result, status);
            status.throwExceptionIfNotOK();
            long l = result[0];
            return l;
        }
    }

    @Override
    public long[] getAttrIntList(String name) {
        try (PointerScope scope = new PointerScope();){
            long size = this.getAttrMetadata((String)name).listSize;
            long[] result = new long[(int)size];
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_OperationGetAttrIntList(this.op.getCheckedNativeHandle(), name, result, result.length, status);
            status.throwExceptionIfNotOK();
            long[] lArray = result;
            return lArray;
        }
    }

    @Override
    public float getAttrFloat(String name) {
        try (PointerScope scope = new PointerScope();){
            float[] result = new float[1];
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_OperationGetAttrFloat(this.op.getCheckedNativeHandle(), name, result, status);
            status.throwExceptionIfNotOK();
            float f = result[0];
            return f;
        }
    }

    @Override
    public float[] getAttrFloatList(String name) {
        try (PointerScope scope = new PointerScope();){
            long size = this.getAttrMetadata((String)name).listSize;
            float[] result = new float[(int)size];
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_OperationGetAttrFloatList(this.op.getCheckedNativeHandle(), name, result, result.length, status);
            status.throwExceptionIfNotOK();
            float[] fArray = result;
            return fArray;
        }
    }

    @Override
    public boolean getAttrBool(String name) {
        try (PointerScope scope = new PointerScope();){
            byte[] result = new byte[1];
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_OperationGetAttrBool(this.op.getCheckedNativeHandle(), name, result, status);
            status.throwExceptionIfNotOK();
            boolean bl = result[0] == 1;
            return bl;
        }
    }

    @Override
    public boolean[] getAttrBoolList(String name) {
        try (PointerScope scope = new PointerScope();){
            long size = this.getAttrMetadata((String)name).listSize;
            byte[] byteResults = new byte[(int)size];
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_OperationGetAttrBoolList(this.op.getCheckedNativeHandle(), name, byteResults, byteResults.length, status);
            status.throwExceptionIfNotOK();
            boolean[] results = new boolean[byteResults.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = byteResults[i] == 1;
            }
            boolean[] blArray = results;
            return blArray;
        }
    }

    @Override
    public DataType getAttrType(String name) {
        try (PointerScope scope = new PointerScope();){
            int[] result = new int[1];
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_OperationGetAttrType(this.op.getCheckedNativeHandle(), name, result, status);
            status.throwExceptionIfNotOK();
            DataType dataType = DataType.forNumber(result[0]);
            return dataType;
        }
    }

    @Override
    public DataType[] getAttrTypeList(String name) {
        try (PointerScope scope = new PointerScope();){
            long size = this.getAttrMetadata((String)name).listSize;
            int[] typeInts = new int[(int)size];
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_OperationGetAttrTypeList(this.op.getCheckedNativeHandle(), name, typeInts, typeInts.length, status);
            status.throwExceptionIfNotOK();
            DataType[] results = new DataType[typeInts.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = DataType.forNumber(typeInts[i]);
            }
            DataType[] dataTypeArray = results;
            return dataTypeArray;
        }
    }

    @Override
    public Tensor getAttrTensor(String name) {
        try (PointerScope scope = new PointerScope();){
            PointerPointer result = new PointerPointer(1L);
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_OperationGetAttrTensor(this.op.getCheckedNativeHandle(), new BytePointer(name), result, status);
            status.throwExceptionIfNotOK();
            RawTensor rawTensor = RawTensor.fromHandle(((TF_Tensor)result.get(TF_Tensor.class, 0L)).withDeallocator());
            return rawTensor;
        }
    }

    @Override
    public Tensor[] getAttrTensorList(String name) {
        try (PointerScope scope = new PointerScope();){
            long size = this.getAttrMetadata((String)name).listSize;
            PointerPointer pointers = new PointerPointer(size);
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_OperationGetAttrTensorList(this.op.getCheckedNativeHandle(), new BytePointer(name), pointers, (int)size, status);
            status.throwExceptionIfNotOK();
            Tensor[] results = new Tensor[(int)size];
            for (int i = 0; i < results.length; ++i) {
                results[i] = RawTensor.fromHandle(((TF_Tensor)pointers.get(TF_Tensor.class, (long)i)).withDeallocator());
            }
            Tensor[] tensorArray = results;
            return tensorArray;
        }
    }

    @Override
    public Shape getAttrShape(String name) {
        try (PointerScope scope = new PointerScope();){
            long size = this.getAttrMetadata((String)name).totalSize;
            if (size == -1L) {
                Shape shape = Shape.unknown();
                return shape;
            }
            long[] result = new long[(int)size];
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_OperationGetAttrShape(this.op.getCheckedNativeHandle(), name, result, result.length, status);
            status.throwExceptionIfNotOK();
            Shape shape = Shape.of(result);
            return shape;
        }
    }

    @Override
    public Shape[] getAttrShapeList(String name) {
        try (PointerScope scope = new PointerScope();){
            AttributeMetadata metadata = this.getAttrMetadata(name);
            int listSize = (int)metadata.listSize;
            int totalSize = (int)metadata.totalSize;
            PointerPointer dimPointers = new PointerPointer((long)listSize);
            IntPointer numDims = new IntPointer((long)listSize);
            LongPointer storage = new LongPointer((long)totalSize);
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_OperationGetAttrShapeList(this.op.getCheckedNativeHandle(), new BytePointer(name), dimPointers, numDims, listSize, storage, totalSize, status);
            status.throwExceptionIfNotOK();
            Shape[] results = new Shape[listSize];
            for (int i = 0; i < results.length; ++i) {
                int length = numDims.get((long)i);
                if (length == -1) {
                    results[i] = Shape.unknown();
                    continue;
                }
                long[] shape = new long[length];
                ((LongPointer)dimPointers.get(LongPointer.class, (long)i)).get(shape);
                results[i] = Shape.of(shape);
            }
            Shape[] shapeArray = results;
            return shapeArray;
        }
    }

    @Override
    public ConcreteFunction getAttrFunction(String name) {
        AttrValue proto = this.getAttrValueProto(name);
        if (!proto.hasFunc()) {
            throw new IllegalArgumentException("Attribute \"" + name + "\" is not a function.");
        }
        return this.op.graph().getFunction(proto.getFunc().getName());
    }

    @Override
    public ConcreteFunction[] getAttrFunctionList(String name) {
        AttrValue proto = this.getAttrValueProto(name);
        if (!proto.hasList()) {
            throw new IllegalArgumentException("Attribute \"" + name + "\" is not a list.");
        }
        AttrValue.ListValue list = proto.getList();
        int size = list.getFuncCount();
        if (size < 0) {
            throw new IllegalArgumentException("Attribute \"" + name + "\" is not a list of functions.");
        }
        if (size == 0) {
            return new ConcreteFunction[0];
        }
        ConcreteFunction[] functions = new ConcreteFunction[size];
        for (int i = 0; i < size; ++i) {
            functions[i] = this.op.graph().getFunction(list.getFunc(i).getName());
        }
        return functions;
    }
}

