/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.ragged;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="RaggedRange", inputsClass=Inputs.class)
public final class RaggedRange<U extends TNumber, T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "RaggedRange";
    private Output<U> rtNestedSplits;
    private Output<T> rtDenseValues;

    public RaggedRange(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.rtNestedSplits = operation.output(outputIdx++);
        this.rtDenseValues = operation.output(outputIdx++);
    }

    public static <U extends TNumber, T extends TNumber> RaggedRange<U, T> create(Scope scope, Operand<T> starts, Operand<T> limits, Operand<T> deltas, Class<U> Tsplits) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(starts.asOutput());
        opBuilder.addInput(limits.asOutput());
        opBuilder.addInput(deltas.asOutput());
        opBuilder.setAttr("Tsplits", Operands.toDataType(Tsplits));
        return new RaggedRange<U, T>(opBuilder.build());
    }

    public static <T extends TNumber> RaggedRange<TInt64, T> create(Scope scope, Operand<T> starts, Operand<T> limits, Operand<T> deltas) {
        return RaggedRange.create(scope, starts, limits, deltas, TInt64.class);
    }

    public Output<U> rtNestedSplits() {
        return this.rtNestedSplits;
    }

    public Output<T> rtDenseValues() {
        return this.rtDenseValues;
    }

    @OpInputsMetadata(outputsClass=RaggedRange.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<RaggedRange<?, T>> {
        public final Operand<T> starts;
        public final Operand<T> limits;
        public final Operand<T> deltas;
        public final DataType T;
        public final DataType Tsplits;

        public Inputs(GraphOperation op) {
            super(new RaggedRange(op), op, Arrays.asList("T", "Tsplits"));
            int inputIndex = 0;
            this.starts = op.input(inputIndex++);
            this.limits = op.input(inputIndex++);
            this.deltas = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Tsplits = op.attributes().getAttrType("Tsplits");
        }
    }
}

