/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.estimator;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

@OpMetadata(opType="BoostedTreesMakeStatsSummary", inputsClass=Inputs.class)
public final class BoostedTreesMakeStatsSummary
extends RawOp
implements Operand<TFloat32> {
    public static final String OP_NAME = "BoostedTreesMakeStatsSummary";
    private Output<TFloat32> statsSummary;

    public BoostedTreesMakeStatsSummary(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.statsSummary = operation.output(outputIdx++);
    }

    public static BoostedTreesMakeStatsSummary create(Scope scope, Operand<TInt32> nodeIds, Operand<TFloat32> gradients, Operand<TFloat32> hessians, Iterable<Operand<TInt32>> bucketizedFeaturesList, Long maxSplits, Long numBuckets) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(nodeIds.asOutput());
        opBuilder.addInput(gradients.asOutput());
        opBuilder.addInput(hessians.asOutput());
        opBuilder.addInputList(Operands.asOutputs(bucketizedFeaturesList));
        opBuilder.setAttr("max_splits", maxSplits);
        opBuilder.setAttr("num_buckets", numBuckets);
        return new BoostedTreesMakeStatsSummary(opBuilder.build());
    }

    public Output<TFloat32> statsSummary() {
        return this.statsSummary;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.statsSummary;
    }

    @OpInputsMetadata(outputsClass=BoostedTreesMakeStatsSummary.class)
    public static class Inputs
    extends RawOpInputs<BoostedTreesMakeStatsSummary> {
        public final Operand<TInt32> nodeIds;
        public final Operand<TFloat32> gradients;
        public final Operand<TFloat32> hessians;
        public final Iterable<Operand<TInt32>> bucketizedFeaturesList;
        public final long maxSplits;
        public final long numBuckets;

        public Inputs(GraphOperation op) {
            super(new BoostedTreesMakeStatsSummary(op), op, Arrays.asList("max_splits", "num_buckets"));
            int inputIndex = 0;
            this.nodeIds = op.input(inputIndex++);
            this.gradients = op.input(inputIndex++);
            this.hessians = op.input(inputIndex++);
            int bucketizedFeaturesListLength = op.inputListLength("bucketized_features_list");
            this.bucketizedFeaturesList = Arrays.asList((Operand[])op.inputList(inputIndex, bucketizedFeaturesListLength));
            inputIndex += bucketizedFeaturesListLength;
            this.maxSplits = op.attributes().getAttrInt("max_splits");
            this.numBuckets = op.attributes().getAttrInt("num_buckets");
        }
    }
}

