/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;

@OpMetadata(opType="Batch", inputsClass=Inputs.class)
public final class Batch
extends RawOp {
    public static final String OP_NAME = "Batch";
    private List<Output<?>> batchedTensors;
    private Output<TInt64> batchIndex;
    private Output<TInt64> id;

    public Batch(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int batchedTensorsLength = operation.outputListLength("batched_tensors");
        this.batchedTensors = Arrays.asList(operation.outputList(outputIdx, batchedTensorsLength));
        outputIdx += batchedTensorsLength;
        this.batchIndex = operation.output(outputIdx++);
        this.id = operation.output(outputIdx++);
    }

    public static Batch create(Scope scope, Iterable<Operand<?>> inTensors, Long numBatchThreads, Long maxBatchSize, Long batchTimeoutMicros, Long gradTimeoutMicros, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(inTensors));
        opBuilder.setAttr("num_batch_threads", numBatchThreads);
        opBuilder.setAttr("max_batch_size", maxBatchSize);
        opBuilder.setAttr("batch_timeout_micros", batchTimeoutMicros);
        opBuilder.setAttr("grad_timeout_micros", gradTimeoutMicros);
        if (options != null) {
            for (Options opts : options) {
                if (opts.maxEnqueuedBatches != null) {
                    opBuilder.setAttr("max_enqueued_batches", opts.maxEnqueuedBatches);
                }
                if (opts.allowedBatchSizes != null) {
                    long[] allowedBatchSizesArray = new long[opts.allowedBatchSizes.size()];
                    for (int i = 0; i < allowedBatchSizesArray.length; ++i) {
                        allowedBatchSizesArray[i] = opts.allowedBatchSizes.get(i);
                    }
                    opBuilder.setAttr("allowed_batch_sizes", allowedBatchSizesArray);
                }
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName != null) {
                    opBuilder.setAttr("shared_name", opts.sharedName);
                }
                if (opts.batchingQueue == null) continue;
                opBuilder.setAttr("batching_queue", opts.batchingQueue);
            }
        }
        return new Batch(opBuilder.build());
    }

    public static Options maxEnqueuedBatches(Long maxEnqueuedBatches) {
        return new Options().maxEnqueuedBatches(maxEnqueuedBatches);
    }

    public static Options allowedBatchSizes(List<Long> allowedBatchSizes) {
        return new Options().allowedBatchSizes(allowedBatchSizes);
    }

    public static Options allowedBatchSizes(Long ... allowedBatchSizes) {
        return new Options().allowedBatchSizes(allowedBatchSizes);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public static Options batchingQueue(String batchingQueue) {
        return new Options().batchingQueue(batchingQueue);
    }

    public List<Output<?>> batchedTensors() {
        return this.batchedTensors;
    }

    public Output<TInt64> batchIndex() {
        return this.batchIndex;
    }

    public Output<TInt64> id() {
        return this.id;
    }

    @OpInputsMetadata(outputsClass=Batch.class)
    public static class Inputs
    extends RawOpInputs<Batch> {
        public final Iterable<Operand<?>> inTensors;
        public final long numBatchThreads;
        public final long maxBatchSize;
        public final long maxEnqueuedBatches;
        public final long batchTimeoutMicros;
        public final long[] allowedBatchSizes;
        public final long gradTimeoutMicros;
        public final String container;
        public final String sharedName;
        public final String batchingQueue;
        public final DataType[] T;

        public Inputs(GraphOperation op) {
            super(new Batch(op), op, Arrays.asList("num_batch_threads", "max_batch_size", "max_enqueued_batches", "batch_timeout_micros", "allowed_batch_sizes", "grad_timeout_micros", "container", "shared_name", "batching_queue", "T"));
            int inputIndex = 0;
            int inTensorsLength = op.inputListLength("in_tensors");
            this.inTensors = Arrays.asList((Operand[])op.inputList(inputIndex, inTensorsLength));
            inputIndex += inTensorsLength;
            this.numBatchThreads = op.attributes().getAttrInt("num_batch_threads");
            this.maxBatchSize = op.attributes().getAttrInt("max_batch_size");
            this.maxEnqueuedBatches = op.attributes().getAttrInt("max_enqueued_batches");
            this.batchTimeoutMicros = op.attributes().getAttrInt("batch_timeout_micros");
            this.allowedBatchSizes = op.attributes().getAttrIntList("allowed_batch_sizes");
            this.gradTimeoutMicros = op.attributes().getAttrInt("grad_timeout_micros");
            this.container = op.attributes().getAttrString("container");
            this.sharedName = op.attributes().getAttrString("shared_name");
            this.batchingQueue = op.attributes().getAttrString("batching_queue");
            this.T = op.attributes().getAttrTypeList("T");
        }
    }

    public static class Options {
        private Long maxEnqueuedBatches;
        private List<Long> allowedBatchSizes;
        private String container;
        private String sharedName;
        private String batchingQueue;

        private Options() {
        }

        public Options maxEnqueuedBatches(Long maxEnqueuedBatches) {
            this.maxEnqueuedBatches = maxEnqueuedBatches;
            return this;
        }

        public Options allowedBatchSizes(List<Long> allowedBatchSizes) {
            this.allowedBatchSizes = allowedBatchSizes;
            return this;
        }

        public Options allowedBatchSizes(Long ... allowedBatchSizes) {
            this.allowedBatchSizes = Arrays.asList(allowedBatchSizes);
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        public Options batchingQueue(String batchingQueue) {
            this.batchingQueue = batchingQueue;
            return this;
        }
    }
}

