/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaConvV2", inputsClass=Inputs.class)
public final class Conv<W extends TType>
extends RawOp
implements Operand<W> {
    public static final String OP_NAME = "XlaConvV2";
    private Output<W> output;

    public Conv(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <W extends TType, V extends TNumber> Conv<W> create(Scope scope, Operand<? extends TType> lhs, Operand<? extends TType> rhs, Operand<V> windowStrides, Operand<V> padding, Operand<V> lhsDilation, Operand<V> rhsDilation, Operand<V> featureGroupCount, String dimensionNumbers, String precisionConfig, Class<W> preferredElementType, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Conv");
        opBuilder.addInput(lhs.asOutput());
        opBuilder.addInput(rhs.asOutput());
        opBuilder.addInput(windowStrides.asOutput());
        opBuilder.addInput(padding.asOutput());
        opBuilder.addInput(lhsDilation.asOutput());
        opBuilder.addInput(rhsDilation.asOutput());
        opBuilder.addInput(featureGroupCount.asOutput());
        opBuilder.setAttr("dimension_numbers", dimensionNumbers);
        opBuilder.setAttr("precision_config", precisionConfig);
        opBuilder.setAttr("preferred_element_type", Operands.toDataType(preferredElementType));
        if (options != null) {
            for (Options opts : options) {
                if (opts.batchGroupCount == null) continue;
                opBuilder.setAttr("batch_group_count", opts.batchGroupCount);
            }
        }
        return new Conv<W>(opBuilder.build());
    }

    public static Options batchGroupCount(Long batchGroupCount) {
        return new Options().batchGroupCount(batchGroupCount);
    }

    public Output<W> output() {
        return this.output;
    }

    @Override
    public Output<W> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=Conv.class)
    public static class Inputs<V extends TNumber>
    extends RawOpInputs<Conv<?>> {
        public final Operand<? extends TType> lhs;
        public final Operand<? extends TType> rhs;
        public final Operand<V> windowStrides;
        public final Operand<V> padding;
        public final Operand<V> lhsDilation;
        public final Operand<V> rhsDilation;
        public final Operand<V> featureGroupCount;
        public final DataType LhsT;
        public final DataType RhsT;
        public final DataType Tindices;
        public final String dimensionNumbers;
        public final String precisionConfig;
        public final DataType preferredElementType;
        public final long batchGroupCount;

        public Inputs(GraphOperation op) {
            super(new Conv(op), op, Arrays.asList("LhsT", "RhsT", "Tindices", "dimension_numbers", "precision_config", "preferred_element_type", "batch_group_count"));
            int inputIndex = 0;
            this.lhs = op.input(inputIndex++);
            this.rhs = op.input(inputIndex++);
            this.windowStrides = op.input(inputIndex++);
            this.padding = op.input(inputIndex++);
            this.lhsDilation = op.input(inputIndex++);
            this.rhsDilation = op.input(inputIndex++);
            this.featureGroupCount = op.input(inputIndex++);
            this.LhsT = op.attributes().getAttrType("LhsT");
            this.RhsT = op.attributes().getAttrType("RhsT");
            this.Tindices = op.attributes().getAttrType("Tindices");
            this.dimensionNumbers = op.attributes().getAttrString("dimension_numbers");
            this.precisionConfig = op.attributes().getAttrString("precision_config");
            this.preferredElementType = op.attributes().getAttrType("preferred_element_type");
            this.batchGroupCount = op.attributes().getAttrInt("batch_group_count");
        }
    }

    public static class Options {
        private Long batchGroupCount;

        private Options() {
        }

        public Options batchGroupCount(Long batchGroupCount) {
            this.batchGroupCount = batchGroupCount;
            return this;
        }
    }
}

