/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TString;
import org.tensorflow.types.TUint8;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="DecodeImage", inputsClass=Inputs.class)
public final class DecodeImage<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "DecodeImage";
    private Output<T> image;

    public DecodeImage(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.image = operation.output(outputIdx++);
    }

    public static <T extends TNumber> DecodeImage<T> create(Scope scope, Operand<TString> contents, Class<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(contents.asOutput());
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.channels != null) {
                    opBuilder.setAttr("channels", opts.channels);
                }
                if (opts.expandAnimations == null) continue;
                opBuilder.setAttr("expand_animations", opts.expandAnimations);
            }
        }
        return new DecodeImage<T>(opBuilder.build());
    }

    public static DecodeImage<TUint8> create(Scope scope, Operand<TString> contents, Options[] options) {
        return DecodeImage.create(scope, contents, TUint8.class, options);
    }

    public static Options channels(Long channels) {
        return new Options().channels(channels);
    }

    public static Options expandAnimations(Boolean expandAnimations) {
        return new Options().expandAnimations(expandAnimations);
    }

    public Output<T> image() {
        return this.image;
    }

    @Override
    public Output<T> asOutput() {
        return this.image;
    }

    @OpInputsMetadata(outputsClass=DecodeImage.class)
    public static class Inputs
    extends RawOpInputs<DecodeImage<?>> {
        public final Operand<TString> contents;
        public final long channels;
        public final DataType dtype;
        public final boolean expandAnimations;

        public Inputs(GraphOperation op) {
            super(new DecodeImage(op), op, Arrays.asList("channels", "dtype", "expand_animations"));
            int inputIndex = 0;
            this.contents = op.input(inputIndex++);
            this.channels = op.attributes().getAttrInt("channels");
            this.dtype = op.attributes().getAttrType("dtype");
            this.expandAnimations = op.attributes().getAttrBool("expand_animations");
        }
    }

    public static class Options {
        private Long channels;
        private Boolean expandAnimations;

        private Options() {
        }

        public Options channels(Long channels) {
            this.channels = channels;
            return this;
        }

        public Options expandAnimations(Boolean expandAnimations) {
            this.expandAnimations = expandAnimations;
            return this;
        }
    }
}

