/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TInt32;

@OpMetadata(opType="DeviceIndex", inputsClass=Inputs.class)
public final class DeviceIndex
extends RawOp
implements Operand<TInt32> {
    public static final String OP_NAME = "DeviceIndex";
    private Output<TInt32> index;

    public DeviceIndex(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.index = operation.output(outputIdx++);
    }

    public static DeviceIndex create(Scope scope, List<String> deviceNames) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        String[] deviceNamesArray = new String[deviceNames.size()];
        for (int i = 0; i < deviceNamesArray.length; ++i) {
            deviceNamesArray[i] = deviceNames.get(i);
        }
        opBuilder.setAttr("device_names", deviceNamesArray);
        return new DeviceIndex(opBuilder.build());
    }

    public Output<TInt32> index() {
        return this.index;
    }

    @Override
    public Output<TInt32> asOutput() {
        return this.index;
    }

    @OpInputsMetadata(outputsClass=DeviceIndex.class)
    public static class Inputs
    extends RawOpInputs<DeviceIndex> {
        public final String[] deviceNames;

        public Inputs(GraphOperation op) {
            super(new DeviceIndex(op), op, Arrays.asList("device_names"));
            boolean inputIndex = false;
            this.deviceNames = op.attributes().getAttrStringList("device_names");
        }
    }
}

