/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tensorflow.Tensor;
import org.tensorflow.exceptions.TensorFlowException;
import org.tensorflow.proto.framework.RunMetadata;

public final class Result
implements AutoCloseable,
Iterable<Map.Entry<String, Tensor>> {
    private final Map<String, Tensor> map;
    private final List<Tensor> list;
    private final RunMetadata metadata;
    private boolean closed;
    private static final Logger logger = Logger.getLogger(Result.class.getName());

    @Override
    public void close() {
        if (!this.closed) {
            for (Tensor t : this.list) {
                try {
                    t.close();
                }
                catch (TensorFlowException e) {
                    logger.log(Level.WARNING, "Exception raised when closing tensor inside result.", e);
                }
            }
            this.closed = true;
        } else {
            logger.warning("Closing an already closed Result");
        }
    }

    @Override
    public Iterator<Map.Entry<String, Tensor>> iterator() {
        if (!this.closed) {
            return this.map.entrySet().iterator();
        }
        throw new IllegalStateException("Result is closed");
    }

    public int size() {
        return this.map.size();
    }

    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public Tensor get(int index) {
        if (!this.closed) {
            return this.list.get(index);
        }
        throw new IllegalStateException("Result is closed");
    }

    public Optional<Tensor> get(String key) {
        if (!this.closed) {
            return Optional.ofNullable(this.map.get(key));
        }
        throw new IllegalStateException("Result is closed");
    }

    public Optional<RunMetadata> getMetadata() {
        return Optional.ofNullable(this.metadata);
    }

    Result(List<String> names, List<Tensor> values, RunMetadata metadata) {
        this.map = new LinkedHashMap<String, Tensor>();
        this.list = new ArrayList<Tensor>(values);
        if (names.size() != values.size()) {
            throw new IllegalArgumentException("Expected same number of names and values, found names.length = " + names.size() + ", values.length = " + values.size());
        }
        for (int i = 0; i < names.size(); ++i) {
            Tensor old = this.map.put(names.get(i), values.get(i));
            if (old == null) continue;
            throw new IllegalArgumentException("Name collision in the result set, two outputs are named '" + names.get(i) + "'");
        }
        this.metadata = metadata;
        this.closed = false;
    }

    Result(LinkedHashMap<String, Tensor> outputs) {
        this.map = outputs;
        this.list = new ArrayList<Tensor>(outputs.size());
        for (Map.Entry<String, Tensor> e : outputs.entrySet()) {
            this.list.add(e.getValue());
        }
        this.metadata = null;
        this.closed = false;
    }
}

