/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.train;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="RestoreV2", inputsClass=Inputs.class)
public final class Restore
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "RestoreV2";
    private List<Output<?>> tensors;

    public Restore(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int tensorsLength = operation.outputListLength("tensors");
        this.tensors = Arrays.asList(operation.outputList(outputIdx, tensorsLength));
        outputIdx += tensorsLength;
    }

    public static Restore create(Scope scope, Operand<TString> prefix, Operand<TString> tensorNames, Operand<TString> shapeAndSlices, List<Class<? extends TType>> dtypes) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Restore");
        opBuilder.addInput(prefix.asOutput());
        opBuilder.addInput(tensorNames.asOutput());
        opBuilder.addInput(shapeAndSlices.asOutput());
        opBuilder.setAttr("dtypes", Operands.toDataTypes(dtypes));
        return new Restore(opBuilder.build());
    }

    public List<Output<?>> tensors() {
        return this.tensors;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.tensors.iterator();
    }

    @OpInputsMetadata(outputsClass=Restore.class)
    public static class Inputs
    extends RawOpInputs<Restore> {
        public final Operand<TString> prefix;
        public final Operand<TString> tensorNames;
        public final Operand<TString> shapeAndSlices;
        public final DataType[] dtypes;

        public Inputs(GraphOperation op) {
            super(new Restore(op), op, Arrays.asList("dtypes"));
            int inputIndex = 0;
            this.prefix = op.input(inputIndex++);
            this.tensorNames = op.input(inputIndex++);
            this.shapeAndSlices = op.input(inputIndex++);
            this.dtypes = op.attributes().getAttrTypeList("dtypes");
        }
    }
}

