/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.estimator;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="BoostedTreesUpdateEnsembleV2", inputsClass=Inputs.class)
public final class BoostedTreesUpdateEnsembleV2
extends RawOp {
    public static final String OP_NAME = "BoostedTreesUpdateEnsembleV2";

    public BoostedTreesUpdateEnsembleV2(Operation operation) {
        super(operation, OP_NAME);
    }

    public static BoostedTreesUpdateEnsembleV2 create(Scope scope, Operand<? extends TType> treeEnsembleHandle, Iterable<Operand<TInt32>> featureIds, Iterable<Operand<TInt32>> dimensionIds, Iterable<Operand<TInt32>> nodeIds, Iterable<Operand<TFloat32>> gains, Iterable<Operand<TInt32>> thresholds, Iterable<Operand<TFloat32>> leftNodeContribs, Iterable<Operand<TFloat32>> rightNodeContribs, Iterable<Operand<TString>> splitTypes, Operand<TInt32> maxDepth, Operand<TFloat32> learningRate, Operand<TInt32> pruningMode, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(treeEnsembleHandle.asOutput());
        opBuilder.addInputList(Operands.asOutputs(featureIds));
        opBuilder.addInputList(Operands.asOutputs(dimensionIds));
        opBuilder.addInputList(Operands.asOutputs(nodeIds));
        opBuilder.addInputList(Operands.asOutputs(gains));
        opBuilder.addInputList(Operands.asOutputs(thresholds));
        opBuilder.addInputList(Operands.asOutputs(leftNodeContribs));
        opBuilder.addInputList(Operands.asOutputs(rightNodeContribs));
        opBuilder.addInputList(Operands.asOutputs(splitTypes));
        opBuilder.addInput(maxDepth.asOutput());
        opBuilder.addInput(learningRate.asOutput());
        opBuilder.addInput(pruningMode.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.logitsDimension != null) {
                    opBuilder.setAttr("logits_dimension", opts.logitsDimension);
                }
                if (opts.numGroups == null) continue;
                opBuilder.setAttr("num_groups", opts.numGroups);
            }
        }
        return new BoostedTreesUpdateEnsembleV2(opBuilder.build());
    }

    public static Options logitsDimension(Long logitsDimension) {
        return new Options().logitsDimension(logitsDimension);
    }

    public static Options numGroups(Long numGroups) {
        return new Options().numGroups(numGroups);
    }

    @OpInputsMetadata(outputsClass=BoostedTreesUpdateEnsembleV2.class)
    public static class Inputs
    extends RawOpInputs<BoostedTreesUpdateEnsembleV2> {
        public final Operand<? extends TType> treeEnsembleHandle;
        public final Iterable<Operand<TInt32>> featureIds;
        public final Iterable<Operand<TInt32>> dimensionIds;
        public final Iterable<Operand<TInt32>> nodeIds;
        public final Iterable<Operand<TFloat32>> gains;
        public final Iterable<Operand<TInt32>> thresholds;
        public final Iterable<Operand<TFloat32>> leftNodeContribs;
        public final Iterable<Operand<TFloat32>> rightNodeContribs;
        public final Iterable<Operand<TString>> splitTypes;
        public final Operand<TInt32> maxDepth;
        public final Operand<TFloat32> learningRate;
        public final Operand<TInt32> pruningMode;
        public final long logitsDimension;

        public Inputs(GraphOperation op) {
            super(new BoostedTreesUpdateEnsembleV2(op), op, Arrays.asList("logits_dimension"));
            int inputIndex = 0;
            this.treeEnsembleHandle = op.input(inputIndex++);
            int featureIdsLength = op.inputListLength("feature_ids");
            this.featureIds = Arrays.asList((Operand[])op.inputList(inputIndex, featureIdsLength));
            int dimensionIdsLength = op.inputListLength("dimension_ids");
            this.dimensionIds = Arrays.asList((Operand[])op.inputList(inputIndex += featureIdsLength, dimensionIdsLength));
            int nodeIdsLength = op.inputListLength("node_ids");
            this.nodeIds = Arrays.asList((Operand[])op.inputList(inputIndex += dimensionIdsLength, nodeIdsLength));
            int gainsLength = op.inputListLength("gains");
            this.gains = Arrays.asList((Operand[])op.inputList(inputIndex += nodeIdsLength, gainsLength));
            int thresholdsLength = op.inputListLength("thresholds");
            this.thresholds = Arrays.asList((Operand[])op.inputList(inputIndex += gainsLength, thresholdsLength));
            int leftNodeContribsLength = op.inputListLength("left_node_contribs");
            this.leftNodeContribs = Arrays.asList((Operand[])op.inputList(inputIndex += thresholdsLength, leftNodeContribsLength));
            int rightNodeContribsLength = op.inputListLength("right_node_contribs");
            this.rightNodeContribs = Arrays.asList((Operand[])op.inputList(inputIndex += leftNodeContribsLength, rightNodeContribsLength));
            int splitTypesLength = op.inputListLength("split_types");
            this.splitTypes = Arrays.asList((Operand[])op.inputList(inputIndex += rightNodeContribsLength, splitTypesLength));
            inputIndex += splitTypesLength;
            this.maxDepth = op.input(inputIndex++);
            this.learningRate = op.input(inputIndex++);
            this.pruningMode = op.input(inputIndex++);
            this.logitsDimension = op.attributes().getAttrInt("logits_dimension");
        }
    }

    public static class Options {
        private Long logitsDimension;
        private Long numGroups;

        private Options() {
        }

        public Options logitsDimension(Long logitsDimension) {
            this.logitsDimension = logitsDimension;
            return this;
        }

        public Options numGroups(Long numGroups) {
            this.numGroups = numGroups;
            return this;
        }
    }
}

