/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SplitV", inputsClass=Inputs.class)
public final class SplitV<T extends TType>
extends RawOp
implements Iterable<Operand<T>> {
    public static final String OP_NAME = "SplitV";
    private List<Output<T>> output;

    public SplitV(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputLength = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(outputIdx, outputLength));
        outputIdx += outputLength;
    }

    public static <T extends TType> SplitV<T> create(Scope scope, Operand<T> value, Operand<? extends TNumber> sizeSplits, Operand<TInt32> axis, Long numSplit) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(value.asOutput());
        opBuilder.addInput(sizeSplits.asOutput());
        opBuilder.addInput(axis.asOutput());
        opBuilder.setAttr("num_split", numSplit);
        return new SplitV<T>(opBuilder.build());
    }

    public List<Output<T>> output() {
        return this.output;
    }

    @Override
    public Iterator<Operand<T>> iterator() {
        return this.output.iterator();
    }

    @OpInputsMetadata(outputsClass=SplitV.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<SplitV<T>> {
        public final Operand<T> value;
        public final Operand<? extends TNumber> sizeSplits;
        public final Operand<TInt32> axis;
        public final DataType T;
        public final DataType Tlen;

        public Inputs(GraphOperation op) {
            super(new SplitV(op), op, Arrays.asList("T", "Tlen"));
            int inputIndex = 0;
            this.value = op.input(inputIndex++);
            this.sizeSplits = op.input(inputIndex++);
            this.axis = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Tlen = op.attributes().getAttrType("Tlen");
        }
    }
}

