/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.concurrent.atomic.AtomicReferenceArray;
import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.AbstractOperation;
import org.tensorflow.EagerSession;
import org.tensorflow.RawTensor;
import org.tensorflow.Tensor;
import org.tensorflow.internal.c_api.TFE_Op;
import org.tensorflow.internal.c_api.TFE_TensorHandle;
import org.tensorflow.internal.c_api.TF_Status;
import org.tensorflow.internal.c_api.TF_Tensor;
import org.tensorflow.internal.c_api.global.tensorflow;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

class EagerOperation
extends AbstractOperation {
    private final EagerSession session;
    private final String type;
    private final String name;
    private final AtomicReferenceArray<Tensor> outputTensors;
    private final TFE_Op opHandle;
    private final TFE_TensorHandle[] outputHandles;

    EagerOperation(EagerSession session, TFE_Op opNativeHandle, TFE_TensorHandle[] outputNativeHandles, String type, String name) {
        this.session = session;
        this.type = type;
        this.name = name;
        this.opHandle = opNativeHandle;
        this.outputHandles = outputNativeHandles;
        this.outputTensors = new AtomicReferenceArray(outputNativeHandles.length);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public EagerSession env() {
        return this.session;
    }

    @Override
    public int numOutputs() {
        return this.outputHandles.length;
    }

    @Override
    public int outputListLength(String name) {
        return EagerOperation.outputListLength(this.opHandle, name);
    }

    @Override
    public int inputListLength(String name) {
        return EagerOperation.inputListLength(this.opHandle, name);
    }

    @Override
    TFE_TensorHandle getUnsafeNativeHandle(int outputIndex) {
        return this.outputHandles[outputIndex];
    }

    public int hashCode() {
        return Long.valueOf(this.opHandle.address()).hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EagerOperation)) {
            return false;
        }
        EagerOperation that = (EagerOperation)o;
        if (this.session != that.session) {
            return false;
        }
        if (this.opHandle == null || that.opHandle == null || this.opHandle.isNull() || that.opHandle.isNull()) {
            return false;
        }
        return this.opHandle.equals((Object)that.opHandle);
    }

    @Override
    Shape shape(int outputIndex) {
        Tensor tensor = this.outputTensors.get(outputIndex);
        if (tensor != null) {
            return tensor.shape();
        }
        TFE_TensorHandle outputNativeHandle = this.getUnsafeNativeHandle(outputIndex);
        long[] shape = new long[EagerOperation.numDims(outputNativeHandle)];
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = EagerOperation.dim(outputNativeHandle, i);
        }
        return Shape.of(shape);
    }

    @Override
    DataType dtype(int outputIndex) {
        Tensor tensor = this.outputTensors.get(outputIndex);
        if (tensor != null) {
            return tensor.dataType();
        }
        TFE_TensorHandle outputNativeHandle = this.getUnsafeNativeHandle(outputIndex);
        return DataType.forNumber(EagerOperation.dataType(outputNativeHandle));
    }

    @Override
    Tensor tensor(int outputIndex) {
        Tensor tensor = this.outputTensors.get(outputIndex);
        if (tensor == null) {
            tensor = this.resolveTensor(outputIndex);
        }
        return tensor;
    }

    private Tensor resolveTensor(int outputIndex) {
        Tensor tensor = EagerOperation.resolveTensorHandle(this.getUnsafeNativeHandle(outputIndex), this.session);
        if (!this.outputTensors.compareAndSet(outputIndex, null, tensor)) {
            this.session.detach(tensor.asRawTensor().nativeHandle());
            tensor = this.outputTensors.get(outputIndex);
        }
        return tensor;
    }

    private static void requireOp(TFE_Op handle) {
        if (handle == null || handle.isNull()) {
            throw new IllegalStateException("Eager session has been closed");
        }
    }

    private static void requireTensorHandle(TFE_TensorHandle handle) {
        if (handle == null || handle.isNull()) {
            throw new IllegalStateException("Eager session has been closed");
        }
    }

    private static Tensor resolveTensorHandle(TFE_TensorHandle handle, EagerSession session) {
        EagerOperation.requireTensorHandle(handle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Status status = TF_Status.newStatus();
            TF_Tensor tensor = tensorflow.TFE_TensorHandleResolve(handle, status);
            status.throwExceptionIfNotOK();
            TType tType = RawTensor.fromHandle(tensor.withDeallocator(), session).asTypedTensor();
            return tType;
        }
    }

    private static int outputListLength(TFE_Op handle, String name) {
        EagerOperation.requireOp(handle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Status status = TF_Status.newStatus();
            int length = tensorflow.TFE_OpGetOutputLength(handle, name, status);
            status.throwExceptionIfNotOK();
            int n = length;
            return n;
        }
    }

    private static int inputListLength(TFE_Op handle, String name) {
        EagerOperation.requireOp(handle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Status status = TF_Status.newStatus();
            int length = tensorflow.TFE_OpGetInputLength(handle, name, status);
            status.throwExceptionIfNotOK();
            int n = length;
            return n;
        }
    }

    private static int dataType(TFE_TensorHandle handle) {
        EagerOperation.requireTensorHandle(handle);
        return tensorflow.TFE_TensorHandleDataType(handle);
    }

    private static int numDims(TFE_TensorHandle handle) {
        EagerOperation.requireTensorHandle(handle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Status status = TF_Status.newStatus();
            int numDims = tensorflow.TFE_TensorHandleNumDims(handle, status);
            status.throwExceptionIfNotOK();
            int n = numDims;
            return n;
        }
    }

    private static long dim(TFE_TensorHandle handle, int index) {
        EagerOperation.requireTensorHandle(handle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Status status = TF_Status.newStatus();
            long dim = tensorflow.TFE_TensorHandleDim(handle, index, status);
            status.throwExceptionIfNotOK();
            long l = dim;
            return l;
        }
    }
}

