/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="AssignVariableXlaConcatND", inputsClass=Inputs.class)
public final class AssignVariableConcatND
extends RawOp {
    public static final String OP_NAME = "AssignVariableXlaConcatND";

    public AssignVariableConcatND(Operation operation) {
        super(operation, OP_NAME);
    }

    public static AssignVariableConcatND create(Scope scope, Operand<? extends TType> resource, Iterable<Operand<? extends TType>> inputs, List<Long> numConcats, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "AssignVariableConcatND");
        opBuilder.addInput(resource.asOutput());
        opBuilder.addInputList(Operands.asOutputs(inputs));
        long[] numConcatsArray = new long[numConcats.size()];
        for (int i = 0; i < numConcatsArray.length; ++i) {
            numConcatsArray[i] = numConcats.get(i);
        }
        opBuilder.setAttr("num_concats", numConcatsArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.paddings == null) continue;
                long[] paddingsArray = new long[opts.paddings.size()];
                for (int i = 0; i < paddingsArray.length; ++i) {
                    paddingsArray[i] = (Long)opts.paddings.get(i);
                }
                opBuilder.setAttr("paddings", paddingsArray);
            }
        }
        return new AssignVariableConcatND(opBuilder.build());
    }

    public static Options paddings(List<Long> paddings) {
        return new Options().paddings(paddings);
    }

    public static Options paddings(Long ... paddings) {
        return new Options().paddings(paddings);
    }

    @OpInputsMetadata(outputsClass=AssignVariableConcatND.class)
    public static class Inputs
    extends RawOpInputs<AssignVariableConcatND> {
        public final Operand<? extends TType> resource;
        public final Iterable<Operand<? extends TType>> inputs;
        public final DataType T;
        public final long[] numConcats;
        public final long[] paddings;

        public Inputs(GraphOperation op) {
            super(new AssignVariableConcatND(op), op, Arrays.asList("T", "num_concats", "paddings"));
            int inputIndex = 0;
            this.resource = op.input(inputIndex++);
            int inputsLength = op.inputListLength("inputs");
            this.inputs = Arrays.asList((Operand[])op.inputList(inputIndex, inputsLength));
            inputIndex += inputsLength;
            this.T = op.attributes().getAttrType("T");
            this.numConcats = op.attributes().getAttrIntList("num_concats");
            this.paddings = op.attributes().getAttrIntList("paddings");
        }
    }

    public static class Options {
        private List<Long> paddings;

        private Options() {
        }

        public Options paddings(List<Long> paddings) {
            this.paddings = paddings;
            return this;
        }

        public Options paddings(Long ... paddings) {
            this.paddings = Arrays.asList(paddings);
            return this;
        }
    }
}

