/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SparseSlice", inputsClass=Inputs.class)
public final class SparseSlice<T extends TType>
extends RawOp {
    public static final String OP_NAME = "SparseSlice";
    private Output<TInt64> outputIndices;
    private Output<T> outputValues;
    private Output<TInt64> outputShape;

    public SparseSlice(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.outputIndices = operation.output(outputIdx++);
        this.outputValues = operation.output(outputIdx++);
        this.outputShape = operation.output(outputIdx++);
    }

    public static <T extends TType> SparseSlice<T> create(Scope scope, Operand<TInt64> indices, Operand<T> values, Operand<TInt64> shape, Operand<TInt64> start, Operand<TInt64> sizeOutput) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(indices.asOutput());
        opBuilder.addInput(values.asOutput());
        opBuilder.addInput(shape.asOutput());
        opBuilder.addInput(start.asOutput());
        opBuilder.addInput(sizeOutput.asOutput());
        return new SparseSlice<T>(opBuilder.build());
    }

    public Output<TInt64> outputIndices() {
        return this.outputIndices;
    }

    public Output<T> outputValues() {
        return this.outputValues;
    }

    public Output<TInt64> outputShape() {
        return this.outputShape;
    }

    @OpInputsMetadata(outputsClass=SparseSlice.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<SparseSlice<T>> {
        public final Operand<TInt64> indices;
        public final Operand<T> values;
        public final Operand<TInt64> shape;
        public final Operand<TInt64> start;
        public final Operand<TInt64> sizeOutput;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new SparseSlice(op), op, Arrays.asList("T"));
            int inputIndex = 0;
            this.indices = op.input(inputIndex++);
            this.values = op.input(inputIndex++);
            this.shape = op.input(inputIndex++);
            this.start = op.input(inputIndex++);
            this.sizeOutput = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
        }
    }
}

