/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="FusedBatchNormGradV3", inputsClass=Inputs.class)
public final class FusedBatchNormGrad<T extends TNumber, U extends TNumber>
extends RawOp {
    public static final String OP_NAME = "FusedBatchNormGradV3";
    private Output<T> xBackprop;
    private Output<U> scaleBackprop;
    private Output<U> offsetBackprop;
    private Output<U> reserveSpace4;
    private Output<U> reserveSpace5;

    public FusedBatchNormGrad(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.xBackprop = operation.output(outputIdx++);
        this.scaleBackprop = operation.output(outputIdx++);
        this.offsetBackprop = operation.output(outputIdx++);
        this.reserveSpace4 = operation.output(outputIdx++);
        this.reserveSpace5 = operation.output(outputIdx++);
    }

    public static <T extends TNumber, U extends TNumber> FusedBatchNormGrad<T, U> create(Scope scope, Operand<T> yBackprop, Operand<T> x, Operand<TFloat32> scale, Operand<U> reserveSpace1, Operand<U> reserveSpace2, Operand<U> reserveSpace3, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "FusedBatchNormGrad");
        opBuilder.addInput(yBackprop.asOutput());
        opBuilder.addInput(x.asOutput());
        opBuilder.addInput(scale.asOutput());
        opBuilder.addInput(reserveSpace1.asOutput());
        opBuilder.addInput(reserveSpace2.asOutput());
        opBuilder.addInput(reserveSpace3.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.epsilon != null) {
                    opBuilder.setAttr("epsilon", opts.epsilon.floatValue());
                }
                if (opts.dataFormat != null) {
                    opBuilder.setAttr("data_format", opts.dataFormat);
                }
                if (opts.isTraining == null) continue;
                opBuilder.setAttr("is_training", opts.isTraining);
            }
        }
        return new FusedBatchNormGrad<T, U>(opBuilder.build());
    }

    public static Options epsilon(Float epsilon) {
        return new Options().epsilon(epsilon);
    }

    public static Options dataFormat(String dataFormat) {
        return new Options().dataFormat(dataFormat);
    }

    public static Options isTraining(Boolean isTraining) {
        return new Options().isTraining(isTraining);
    }

    public Output<T> xBackprop() {
        return this.xBackprop;
    }

    public Output<U> scaleBackprop() {
        return this.scaleBackprop;
    }

    public Output<U> offsetBackprop() {
        return this.offsetBackprop;
    }

    public Output<U> reserveSpace4() {
        return this.reserveSpace4;
    }

    public Output<U> reserveSpace5() {
        return this.reserveSpace5;
    }

    @OpInputsMetadata(outputsClass=FusedBatchNormGrad.class)
    public static class Inputs<T extends TNumber, U extends TNumber>
    extends RawOpInputs<FusedBatchNormGrad<T, U>> {
        public final Operand<T> yBackprop;
        public final Operand<T> x;
        public final Operand<TFloat32> scale;
        public final Operand<U> reserveSpace1;
        public final Operand<U> reserveSpace2;
        public final Operand<U> reserveSpace3;
        public final DataType T;
        public final DataType U;
        public final float epsilon;
        public final String dataFormat;
        public final boolean isTraining;

        public Inputs(GraphOperation op) {
            super(new FusedBatchNormGrad(op), op, Arrays.asList("T", "U", "epsilon", "data_format", "is_training"));
            int inputIndex = 0;
            this.yBackprop = op.input(inputIndex++);
            this.x = op.input(inputIndex++);
            this.scale = op.input(inputIndex++);
            this.reserveSpace1 = op.input(inputIndex++);
            this.reserveSpace2 = op.input(inputIndex++);
            this.reserveSpace3 = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.U = op.attributes().getAttrType("U");
            this.epsilon = op.attributes().getAttrFloat("epsilon");
            this.dataFormat = op.attributes().getAttrString("data_format");
            this.isTraining = op.attributes().getAttrBool("is_training");
        }
    }

    public static class Options {
        private Float epsilon;
        private String dataFormat;
        private Boolean isTraining;

        private Options() {
        }

        public Options epsilon(Float epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public Options dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Options isTraining(Boolean isTraining) {
            this.isTraining = isTraining;
            return this;
        }
    }
}

