/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TString;

@OpMetadata(opType="ConfigureDistributedTPU", inputsClass=Inputs.class)
public final class ConfigureDistributedTPU
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "ConfigureDistributedTPU";
    private Output<TString> topology;

    public ConfigureDistributedTPU(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.topology = operation.output(outputIdx++);
    }

    public static ConfigureDistributedTPU create(Scope scope, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        if (options != null) {
            for (Options opts : options) {
                if (opts.embeddingConfig != null) {
                    opBuilder.setAttr("embedding_config", opts.embeddingConfig);
                }
                if (opts.tpuEmbeddingConfig != null) {
                    opBuilder.setAttr("tpu_embedding_config", opts.tpuEmbeddingConfig);
                }
                if (opts.isGlobalInit != null) {
                    opBuilder.setAttr("is_global_init", opts.isGlobalInit);
                }
                if (opts.enableWholeMeshCompilations != null) {
                    opBuilder.setAttr("enable_whole_mesh_compilations", opts.enableWholeMeshCompilations);
                }
                if (opts.compilationFailureClosesChips != null) {
                    opBuilder.setAttr("compilation_failure_closes_chips", opts.compilationFailureClosesChips);
                }
                if (opts.tpuCancellationClosesChips == null) continue;
                opBuilder.setAttr("tpu_cancellation_closes_chips", opts.tpuCancellationClosesChips);
            }
        }
        return new ConfigureDistributedTPU(opBuilder.build());
    }

    public static Options embeddingConfig(String embeddingConfig) {
        return new Options().embeddingConfig(embeddingConfig);
    }

    public static Options tpuEmbeddingConfig(String tpuEmbeddingConfig) {
        return new Options().tpuEmbeddingConfig(tpuEmbeddingConfig);
    }

    public static Options isGlobalInit(Boolean isGlobalInit) {
        return new Options().isGlobalInit(isGlobalInit);
    }

    public static Options enableWholeMeshCompilations(Boolean enableWholeMeshCompilations) {
        return new Options().enableWholeMeshCompilations(enableWholeMeshCompilations);
    }

    public static Options compilationFailureClosesChips(Boolean compilationFailureClosesChips) {
        return new Options().compilationFailureClosesChips(compilationFailureClosesChips);
    }

    public static Options tpuCancellationClosesChips(Long tpuCancellationClosesChips) {
        return new Options().tpuCancellationClosesChips(tpuCancellationClosesChips);
    }

    public Output<TString> topology() {
        return this.topology;
    }

    @Override
    public Output<TString> asOutput() {
        return this.topology;
    }

    @OpInputsMetadata(outputsClass=ConfigureDistributedTPU.class)
    public static class Inputs
    extends RawOpInputs<ConfigureDistributedTPU> {
        public final String embeddingConfig;
        public final String tpuEmbeddingConfig;
        public final boolean isGlobalInit;
        public final boolean enableWholeMeshCompilations;
        public final boolean compilationFailureClosesChips;
        public final long tpuCancellationClosesChips;

        public Inputs(GraphOperation op) {
            super(new ConfigureDistributedTPU(op), op, Arrays.asList("embedding_config", "tpu_embedding_config", "is_global_init", "enable_whole_mesh_compilations", "compilation_failure_closes_chips", "tpu_cancellation_closes_chips"));
            boolean inputIndex = false;
            this.embeddingConfig = op.attributes().getAttrString("embedding_config");
            this.tpuEmbeddingConfig = op.attributes().getAttrString("tpu_embedding_config");
            this.isGlobalInit = op.attributes().getAttrBool("is_global_init");
            this.enableWholeMeshCompilations = op.attributes().getAttrBool("enable_whole_mesh_compilations");
            this.compilationFailureClosesChips = op.attributes().getAttrBool("compilation_failure_closes_chips");
            this.tpuCancellationClosesChips = op.attributes().getAttrInt("tpu_cancellation_closes_chips");
        }
    }

    public static class Options {
        private String embeddingConfig;
        private String tpuEmbeddingConfig;
        private Boolean isGlobalInit;
        private Boolean enableWholeMeshCompilations;
        private Boolean compilationFailureClosesChips;
        private Long tpuCancellationClosesChips;

        private Options() {
        }

        public Options embeddingConfig(String embeddingConfig) {
            this.embeddingConfig = embeddingConfig;
            return this;
        }

        public Options tpuEmbeddingConfig(String tpuEmbeddingConfig) {
            this.tpuEmbeddingConfig = tpuEmbeddingConfig;
            return this;
        }

        public Options isGlobalInit(Boolean isGlobalInit) {
            this.isGlobalInit = isGlobalInit;
            return this;
        }

        public Options enableWholeMeshCompilations(Boolean enableWholeMeshCompilations) {
            this.enableWholeMeshCompilations = enableWholeMeshCompilations;
            return this;
        }

        public Options compilationFailureClosesChips(Boolean compilationFailureClosesChips) {
            this.compilationFailureClosesChips = compilationFailureClosesChips;
            return this;
        }

        public Options tpuCancellationClosesChips(Long tpuCancellationClosesChips) {
            this.tpuCancellationClosesChips = tpuCancellationClosesChips;
            return this;
        }
    }
}

