/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.estimator;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

@OpMetadata(opType="BoostedTreesBucketize", inputsClass=Inputs.class)
public final class BoostedTreesBucketize
extends RawOp
implements Iterable<Operand<TInt32>> {
    public static final String OP_NAME = "BoostedTreesBucketize";
    private List<Output<TInt32>> buckets;

    public BoostedTreesBucketize(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int bucketsLength = operation.outputListLength("buckets");
        this.buckets = Arrays.asList(operation.outputList(outputIdx, bucketsLength));
        outputIdx += bucketsLength;
    }

    public static BoostedTreesBucketize create(Scope scope, Iterable<Operand<TFloat32>> floatValues, Iterable<Operand<TFloat32>> bucketBoundaries) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(floatValues));
        opBuilder.addInputList(Operands.asOutputs(bucketBoundaries));
        return new BoostedTreesBucketize(opBuilder.build());
    }

    public List<Output<TInt32>> buckets() {
        return this.buckets;
    }

    @Override
    public Iterator<Operand<TInt32>> iterator() {
        return this.buckets.iterator();
    }

    @OpInputsMetadata(outputsClass=BoostedTreesBucketize.class)
    public static class Inputs
    extends RawOpInputs<BoostedTreesBucketize> {
        public final Iterable<Operand<TFloat32>> floatValues;
        public final Iterable<Operand<TFloat32>> bucketBoundaries;

        public Inputs(GraphOperation op) {
            super(new BoostedTreesBucketize(op), op, Arrays.asList(new String[0]));
            int inputIndex = 0;
            int floatValuesLength = op.inputListLength("float_values");
            this.floatValues = Arrays.asList((Operand[])op.inputList(inputIndex, floatValuesLength));
            int bucketBoundariesLength = op.inputListLength("bucket_boundaries");
            this.bucketBoundaries = Arrays.asList((Operand[])op.inputList(inputIndex += floatValuesLength, bucketBoundariesLength));
            inputIndex += bucketBoundariesLength;
        }
    }
}

