/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.tensorflow.DeviceSpec;
import org.tensorflow.ExecutionEnvironment;
import org.tensorflow.Graph;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.internal.c_api.NativeOperation;
import org.tensorflow.internal.c_api.TF_Scope;
import org.tensorflow.op.Op;
import org.tensorflow.op.Scope;

public final class GradientScope
implements Scope {
    private final Graph graph;
    private final TF_Scope nativeScope;
    private final String opName;
    private final String device;

    @Override
    public ExecutionEnvironment env() {
        return this.graph;
    }

    @Override
    public GradientScope withSubScope(String childScopeName) {
        return new GradientScope(this.nativeScope.NewSubScope(childScopeName), this.graph, null, this.device);
    }

    @Override
    public GradientScope withName(String opName) {
        return new GradientScope(this.nativeScope, this.graph, opName, this.device);
    }

    @Override
    public GradientScope withNameAsSubScope(String defaultName) {
        if (this.opName == null) {
            return this.withSubScope(defaultName);
        }
        return this.withSubScope(this.opName);
    }

    @Override
    public GradientScope withDevice(DeviceSpec newDevice) {
        return new GradientScope(this.nativeScope.WithDevice(newDevice.toString()), this.graph, newDevice.toString());
    }

    @Override
    public Scope withInitScope() {
        throw new IllegalStateException("Can't add init operations in a gradient scope");
    }

    @Override
    public String makeOpName(String defaultName) {
        String name = this.opName != null ? this.opName : defaultName;
        return this.nativeScope.GetUniqueNameForOp(name);
    }

    @Override
    public String makeUnique(String id) {
        return this.nativeScope.GetUniqueNameForOp(id);
    }

    @Override
    public void refreshNames() {
    }

    @Override
    public GradientScope withControlDependencies(Iterable<Op> controls) {
        List controlDeps = StreamSupport.stream(controls.spliterator(), false).collect(Collectors.toList());
        NativeOperation ops = new NativeOperation(controlDeps.size());
        for (int i = 0; i < controlDeps.size(); ++i) {
            Operation op = ((Op)controlDeps.get(i)).op();
            if (!(op instanceof GraphOperation)) {
                throw new IllegalArgumentException("Can only add graph ops as control dependencies");
            }
            ops.position(i).put(new NativeOperation(((GraphOperation)op).getUnsafeNativeHandle().node()));
        }
        return new GradientScope(this.nativeScope.WithControlDependencies(new NativeOperation(ops)), this.graph, this.device);
    }

    @Override
    public Scope withControlDependencyOps(Iterable<Operation> controls) {
        List controlDeps = StreamSupport.stream(controls.spliterator(), false).collect(Collectors.toList());
        NativeOperation ops = new NativeOperation(controlDeps.size());
        for (int i = 0; i < controlDeps.size(); ++i) {
            Operation op = (Operation)controlDeps.get(i);
            if (!(op instanceof GraphOperation)) {
                throw new IllegalArgumentException("Can only add graph ops as control dependencies");
            }
            ops.position(i).put(new NativeOperation(((GraphOperation)op).getUnsafeNativeHandle().node()));
        }
        return new GradientScope(this.nativeScope.WithControlDependencies(new NativeOperation(ops)), this.graph, this.device);
    }

    @Override
    public OperationBuilder apply(OperationBuilder builder) {
        return builder;
    }

    @Override
    public void onOpCreated(Operation op) {
    }

    @Override
    public String getDeviceString() {
        if (this.device == null) {
            throw new UnsupportedOperationException("Can't get device string for gradient scope unless it has been explicitly set");
        }
        return this.device;
    }

    @Override
    public boolean isInit() {
        return false;
    }

    GradientScope(TF_Scope nativeScope, Graph graph, String device) {
        this(nativeScope, graph, null, device);
    }

    private GradientScope(TF_Scope nativeScope, Graph graph, String opName, String device) {
        this.graph = graph;
        this.nativeScope = nativeScope;
        this.opName = opName;
        this.device = device;
    }
}

