/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.types;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.tensorflow.RawTensor;
import org.tensorflow.TensorMapper;
import org.tensorflow.internal.buffer.ByteSequenceProvider;
import org.tensorflow.internal.buffer.ByteSequenceTensorBuffer;
import org.tensorflow.internal.buffer.TensorBuffers;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.layout.DataLayout;
import org.tensorflow.ndarray.buffer.layout.DataLayouts;
import org.tensorflow.ndarray.impl.dense.DenseNdArray;
import org.tensorflow.types.TString;

public final class TStringMapper
extends TensorMapper<TString> {
    private static final DataLayout<DataBuffer<byte[]>, String> UTF_8_LAYOUT = DataLayouts.ofStrings(StandardCharsets.UTF_8);

    @Override
    protected TString mapDense(RawTensor tensor) {
        ByteSequenceTensorBuffer buffer = TensorBuffers.toStrings(TStringMapper.nativeHandle(tensor), tensor.shape().size());
        return new DenseTString(tensor, buffer, UTF_8_LAYOUT);
    }

    private static final class DenseTString
    extends DenseNdArray<String>
    implements TStringInternal {
        final RawTensor rawTensor;
        final ByteSequenceTensorBuffer buffer;

        @Override
        public <T> void init(ByteSequenceProvider<T> byteSequenceProvider) {
            this.buffer.init(byteSequenceProvider);
        }

        @Override
        public TString using(Charset charset) {
            return new DenseTString(this.rawTensor, this.buffer, DataLayouts.ofStrings(charset));
        }

        @Override
        public NdArray<byte[]> asBytes() {
            return NdArrays.wrap(this.shape(), this.buffer);
        }

        public Class<TString> type() {
            return TString.class;
        }

        @Override
        public RawTensor asRawTensor() {
            return this.rawTensor;
        }

        DenseTString(RawTensor rawTensor, ByteSequenceTensorBuffer buffer, DataLayout<DataBuffer<byte[]>, String> layout) {
            super(layout.applyTo(buffer), rawTensor.shape());
            this.rawTensor = rawTensor;
            this.buffer = buffer;
        }
    }

    static interface TStringInternal
    extends TString {
        public <T> void init(ByteSequenceProvider<T> var1);
    }
}

