/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.strings;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="UnsortedSegmentJoin", inputsClass=Inputs.class)
public final class UnsortedSegmentJoin
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "UnsortedSegmentJoin";
    private Output<TString> output;

    public UnsortedSegmentJoin(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static UnsortedSegmentJoin create(Scope scope, Operand<TString> inputs, Operand<? extends TNumber> segmentIds, Operand<? extends TNumber> numSegments, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputs.asOutput());
        opBuilder.addInput(segmentIds.asOutput());
        opBuilder.addInput(numSegments.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.separator == null) continue;
                opBuilder.setAttr("separator", opts.separator);
            }
        }
        return new UnsortedSegmentJoin(opBuilder.build());
    }

    public static Options separator(String separator) {
        return new Options().separator(separator);
    }

    public Output<TString> output() {
        return this.output;
    }

    @Override
    public Output<TString> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=UnsortedSegmentJoin.class)
    public static class Inputs
    extends RawOpInputs<UnsortedSegmentJoin> {
        public final Operand<TString> inputs;
        public final Operand<? extends TNumber> segmentIds;
        public final Operand<? extends TNumber> numSegments;
        public final String separator;
        public final DataType Tindices;
        public final DataType Tnumsegments;

        public Inputs(GraphOperation op) {
            super(new UnsortedSegmentJoin(op), op, Arrays.asList("separator", "Tindices", "Tnumsegments"));
            int inputIndex = 0;
            this.inputs = op.input(inputIndex++);
            this.segmentIds = op.input(inputIndex++);
            this.numSegments = op.input(inputIndex++);
            this.separator = op.attributes().getAttrString("separator");
            this.Tindices = op.attributes().getAttrType("Tindices");
            this.Tnumsegments = op.attributes().getAttrType("Tnumsegments");
        }
    }

    public static class Options {
        private String separator;

        private Options() {
        }

        public Options separator(String separator) {
            this.separator = separator;
            return this;
        }
    }
}

