/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="Conv3DBackpropInputV2", inputsClass=Inputs.class)
public final class Conv3dBackpropInput<U extends TNumber>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "Conv3DBackpropInputV2";
    private Output<U> output;

    public Conv3dBackpropInput(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <U extends TNumber> Conv3dBackpropInput<U> create(Scope scope, Operand<? extends TNumber> inputSizes, Operand<U> filter, Operand<U> outBackprop, List<Long> strides, String padding, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Conv3dBackpropInput");
        opBuilder.addInput(inputSizes.asOutput());
        opBuilder.addInput(filter.asOutput());
        opBuilder.addInput(outBackprop.asOutput());
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        opBuilder.setAttr("padding", padding);
        if (options != null) {
            for (Options opts : options) {
                if (opts.dataFormat != null) {
                    opBuilder.setAttr("data_format", opts.dataFormat);
                }
                if (opts.dilations == null) continue;
                long[] dilationsArray = new long[opts.dilations.size()];
                for (int i = 0; i < dilationsArray.length; ++i) {
                    dilationsArray[i] = (Long)opts.dilations.get(i);
                }
                opBuilder.setAttr("dilations", dilationsArray);
            }
        }
        return new Conv3dBackpropInput<U>(opBuilder.build());
    }

    public static Options dataFormat(String dataFormat) {
        return new Options().dataFormat(dataFormat);
    }

    public static Options dilations(List<Long> dilations) {
        return new Options().dilations(dilations);
    }

    public static Options dilations(Long ... dilations) {
        return new Options().dilations(dilations);
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=Conv3dBackpropInput.class)
    public static class Inputs<U extends TNumber>
    extends RawOpInputs<Conv3dBackpropInput<U>> {
        public final Operand<? extends TNumber> inputSizes;
        public final Operand<U> filter;
        public final Operand<U> outBackprop;
        public final DataType T;
        public final long[] strides;
        public final String padding;
        public final String dataFormat;
        public final long[] dilations;
        public final DataType Tshape;

        public Inputs(GraphOperation op) {
            super(new Conv3dBackpropInput(op), op, Arrays.asList("T", "strides", "padding", "data_format", "dilations", "Tshape"));
            int inputIndex = 0;
            this.inputSizes = op.input(inputIndex++);
            this.filter = op.input(inputIndex++);
            this.outBackprop = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.strides = op.attributes().getAttrIntList("strides");
            this.padding = op.attributes().getAttrString("padding");
            this.dataFormat = op.attributes().getAttrString("data_format");
            this.dilations = op.attributes().getAttrIntList("dilations");
            this.Tshape = op.attributes().getAttrType("Tshape");
        }
    }

    public static class Options {
        private String dataFormat;
        private List<Long> dilations;

        private Options() {
        }

        public Options dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Options dilations(List<Long> dilations) {
            this.dilations = dilations;
            return this;
        }

        public Options dilations(Long ... dilations) {
            this.dilations = Arrays.asList(dilations);
            return this;
        }
    }
}

