/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.estimator;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="BoostedTreesPredict", inputsClass=Inputs.class)
public final class BoostedTreesPredict
extends RawOp
implements Operand<TFloat32> {
    public static final String OP_NAME = "BoostedTreesPredict";
    private Output<TFloat32> logits;

    public BoostedTreesPredict(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.logits = operation.output(outputIdx++);
    }

    public static BoostedTreesPredict create(Scope scope, Operand<? extends TType> treeEnsembleHandle, Iterable<Operand<TInt32>> bucketizedFeatures, Long logitsDimension) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(treeEnsembleHandle.asOutput());
        opBuilder.addInputList(Operands.asOutputs(bucketizedFeatures));
        opBuilder.setAttr("logits_dimension", logitsDimension);
        return new BoostedTreesPredict(opBuilder.build());
    }

    public Output<TFloat32> logits() {
        return this.logits;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.logits;
    }

    @OpInputsMetadata(outputsClass=BoostedTreesPredict.class)
    public static class Inputs
    extends RawOpInputs<BoostedTreesPredict> {
        public final Operand<? extends TType> treeEnsembleHandle;
        public final Iterable<Operand<TInt32>> bucketizedFeatures;
        public final long logitsDimension;

        public Inputs(GraphOperation op) {
            super(new BoostedTreesPredict(op), op, Arrays.asList("logits_dimension"));
            int inputIndex = 0;
            this.treeEnsembleHandle = op.input(inputIndex++);
            int bucketizedFeaturesLength = op.inputListLength("bucketized_features");
            this.bucketizedFeatures = Arrays.asList((Operand[])op.inputList(inputIndex, bucketizedFeaturesLength));
            inputIndex += bucketizedFeaturesLength;
            this.logitsDimension = op.attributes().getAttrInt("logits_dimension");
        }
    }
}

