/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ResourceGather", inputsClass=Inputs.class)
public final class ResourceGather<U extends TType>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "ResourceGather";
    private Output<U> output;

    public ResourceGather(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <U extends TType> ResourceGather<U> create(Scope scope, Operand<? extends TType> resource, Operand<? extends TNumber> indices, Class<U> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(resource.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.batchDims != null) {
                    opBuilder.setAttr("batch_dims", opts.batchDims);
                }
                if (opts.validateIndices == null) continue;
                opBuilder.setAttr("validate_indices", opts.validateIndices);
            }
        }
        return new ResourceGather<U>(opBuilder.build());
    }

    public static Options batchDims(Long batchDims) {
        return new Options().batchDims(batchDims);
    }

    public static Options validateIndices(Boolean validateIndices) {
        return new Options().validateIndices(validateIndices);
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=ResourceGather.class)
    public static class Inputs
    extends RawOpInputs<ResourceGather<?>> {
        public final Operand<? extends TType> resource;
        public final Operand<? extends TNumber> indices;
        public final long batchDims;
        public final boolean validateIndices;
        public final DataType dtype;
        public final DataType Tindices;

        public Inputs(GraphOperation op) {
            super(new ResourceGather(op), op, Arrays.asList("batch_dims", "validate_indices", "dtype", "Tindices"));
            int inputIndex = 0;
            this.resource = op.input(inputIndex++);
            this.indices = op.input(inputIndex++);
            this.batchDims = op.attributes().getAttrInt("batch_dims");
            this.validateIndices = op.attributes().getAttrBool("validate_indices");
            this.dtype = op.attributes().getAttrType("dtype");
            this.Tindices = op.attributes().getAttrType("Tindices");
        }
    }

    public static class Options {
        private Long batchDims;
        private Boolean validateIndices;

        private Options() {
        }

        public Options batchDims(Long batchDims) {
            this.batchDims = batchDims;
            return this;
        }

        public Options validateIndices(Boolean validateIndices) {
            this.validateIndices = validateIndices;
            return this;
        }
    }
}

