/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaReduce", inputsClass=Inputs.class)
public final class Reduce<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "XlaReduce";
    private Output<T> output;

    public Reduce(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> Reduce<T> create(Scope scope, Operand<T> input, Operand<T> initValue, List<Long> dimensionsToReduce, ConcreteFunction reducer) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Reduce");
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(initValue.asOutput());
        long[] dimensionsToReduceArray = new long[dimensionsToReduce.size()];
        for (int i = 0; i < dimensionsToReduceArray.length; ++i) {
            dimensionsToReduceArray[i] = dimensionsToReduce.get(i);
        }
        opBuilder.setAttr("dimensions_to_reduce", dimensionsToReduceArray);
        opBuilder.setAttr("reducer", reducer);
        return new Reduce<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=Reduce.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<Reduce<T>> {
        public final Operand<T> input;
        public final Operand<T> initValue;
        public final DataType T;
        public final long[] dimensionsToReduce;

        public Inputs(GraphOperation op) {
            super(new Reduce(op), op, Arrays.asList("T", "dimensions_to_reduce"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.initValue = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.dimensionsToReduce = op.attributes().getAttrIntList("dimensions_to_reduce");
        }
    }
}

