/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="UnbatchGrad", inputsClass=Inputs.class)
public final class UnbatchGrad<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "UnbatchGrad";
    private Output<T> batchedGrad;

    public UnbatchGrad(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.batchedGrad = operation.output(outputIdx++);
    }

    public static <T extends TType> UnbatchGrad<T> create(Scope scope, Operand<T> originalInput, Operand<TInt64> batchIndex, Operand<T> grad, Operand<TInt64> id, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(originalInput.asOutput());
        opBuilder.addInput(batchIndex.asOutput());
        opBuilder.addInput(grad.asOutput());
        opBuilder.addInput(id.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new UnbatchGrad<T>(opBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public Output<T> batchedGrad() {
        return this.batchedGrad;
    }

    @Override
    public Output<T> asOutput() {
        return this.batchedGrad;
    }

    @OpInputsMetadata(outputsClass=UnbatchGrad.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<UnbatchGrad<T>> {
        public final Operand<T> originalInput;
        public final Operand<TInt64> batchIndex;
        public final Operand<T> grad;
        public final Operand<TInt64> id;
        public final String container;
        public final String sharedName;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new UnbatchGrad(op), op, Arrays.asList("container", "shared_name", "T"));
            int inputIndex = 0;
            this.originalInput = op.input(inputIndex++);
            this.batchIndex = op.input(inputIndex++);
            this.grad = op.input(inputIndex++);
            this.id = op.input(inputIndex++);
            this.container = op.attributes().getAttrString("container");
            this.sharedName = op.attributes().getAttrString("shared_name");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private String container;
        private String sharedName;

        private Options() {
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }
    }
}

