/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="QuantizedReshape", inputsClass=Inputs.class)
public final class QuantizedReshape<T extends TType>
extends RawOp {
    public static final String OP_NAME = "QuantizedReshape";
    private Output<T> output;
    private Output<TFloat32> outputMin;
    private Output<TFloat32> outputMax;

    public QuantizedReshape(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.outputMin = operation.output(outputIdx++);
        this.outputMax = operation.output(outputIdx++);
    }

    public static <T extends TType> QuantizedReshape<T> create(Scope scope, Operand<T> tensor, Operand<? extends TNumber> shape, Operand<TFloat32> inputMin, Operand<TFloat32> inputMax) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(tensor.asOutput());
        opBuilder.addInput(shape.asOutput());
        opBuilder.addInput(inputMin.asOutput());
        opBuilder.addInput(inputMax.asOutput());
        return new QuantizedReshape<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    public Output<TFloat32> outputMin() {
        return this.outputMin;
    }

    public Output<TFloat32> outputMax() {
        return this.outputMax;
    }

    @OpInputsMetadata(outputsClass=QuantizedReshape.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<QuantizedReshape<T>> {
        public final Operand<T> tensor;
        public final Operand<? extends TNumber> shape;
        public final Operand<TFloat32> inputMin;
        public final Operand<TFloat32> inputMax;
        public final DataType T;
        public final DataType Tshape;

        public Inputs(GraphOperation op) {
            super(new QuantizedReshape(op), op, Arrays.asList("T", "Tshape"));
            int inputIndex = 0;
            this.tensor = op.input(inputIndex++);
            this.shape = op.input(inputIndex++);
            this.inputMin = op.input(inputIndex++);
            this.inputMax = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Tshape = op.attributes().getAttrType("Tshape");
        }
    }
}

