/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;

public final class LoadTPUEmbeddingMomentumParameters
extends RawOp {
    public static final String OP_NAME = "LoadTPUEmbeddingMomentumParameters";

    public static LoadTPUEmbeddingMomentumParameters create(Scope scope, Operand<TFloat32> parameters, Operand<TFloat32> momenta, Long numShards, Long shardId, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(parameters.asOutput());
        opBuilder.addInput(momenta.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("num_shards", numShards);
        opBuilder.setAttr("shard_id", shardId);
        if (options != null) {
            for (Options opts : options) {
                if (opts.tableId != null) {
                    opBuilder.setAttr("table_id", opts.tableId);
                }
                if (opts.tableName != null) {
                    opBuilder.setAttr("table_name", opts.tableName);
                }
                if (opts.config == null) continue;
                opBuilder.setAttr("config", opts.config);
            }
        }
        return new LoadTPUEmbeddingMomentumParameters(opBuilder.build());
    }

    public static Options tableId(Long tableId) {
        return new Options().tableId(tableId);
    }

    public static Options tableName(String tableName) {
        return new Options().tableName(tableName);
    }

    public static Options config(String config) {
        return new Options().config(config);
    }

    private LoadTPUEmbeddingMomentumParameters(Operation operation) {
        super(operation);
    }

    public static class Options {
        private Long tableId;
        private String tableName;
        private String config;

        public Options tableId(Long tableId) {
            this.tableId = tableId;
            return this;
        }

        public Options tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Options config(String config) {
            this.config = config;
            return this;
        }

        private Options() {
        }
    }
}

