/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

public final class SparseSlice<T extends TType>
extends RawOp {
    public static final String OP_NAME = "SparseSlice";
    private Output<TInt64> outputIndices;
    private Output<T> outputValues;
    private Output<TInt64> outputShape;

    public static <T extends TType> SparseSlice<T> create(Scope scope, Operand<TInt64> indices, Operand<T> values, Operand<TInt64> shape, Operand<TInt64> start, Operand<TInt64> size) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(indices.asOutput());
        opBuilder.addInput(values.asOutput());
        opBuilder.addInput(shape.asOutput());
        opBuilder.addInput(start.asOutput());
        opBuilder.addInput(size.asOutput());
        opBuilder = scope.apply(opBuilder);
        return new SparseSlice<T>(opBuilder.build());
    }

    public Output<TInt64> outputIndices() {
        return this.outputIndices;
    }

    public Output<T> outputValues() {
        return this.outputValues;
    }

    public Output<TInt64> outputShape() {
        return this.outputShape;
    }

    private SparseSlice(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.outputIndices = operation.output(outputIdx++);
        this.outputValues = operation.output(outputIdx++);
        this.outputShape = operation.output(outputIdx++);
    }
}

