/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.estimator;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;

public final class BoostedTreesFlushQuantileSummaries
extends RawOp
implements Iterable<Operand<TFloat32>> {
    public static final String OP_NAME = "BoostedTreesFlushQuantileSummaries";
    private List<Output<TFloat32>> summaries;

    public static BoostedTreesFlushQuantileSummaries create(Scope scope, Operand<?> quantileStreamResourceHandle, Long numFeatures) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(quantileStreamResourceHandle.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("num_features", numFeatures);
        return new BoostedTreesFlushQuantileSummaries(opBuilder.build());
    }

    public List<Output<TFloat32>> summaries() {
        return this.summaries;
    }

    @Override
    public Iterator<Operand<TFloat32>> iterator() {
        return this.summaries.iterator();
    }

    private BoostedTreesFlushQuantileSummaries(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int summariesLength = operation.outputListLength("summaries");
        this.summaries = Arrays.asList(operation.outputList(outputIdx, summariesLength));
        outputIdx += summariesLength;
    }
}

