/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.debugging;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

public final class DebugNanCount
extends RawOp
implements Operand<TInt64> {
    public static final String OP_NAME = "DebugNanCount";
    private Output<TInt64> output;

    public static DebugNanCount create(Scope scope, Operand<? extends TType> input, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(input.asOutput());
        opBuilder = scope.apply(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.deviceName != null) {
                    opBuilder.setAttr("device_name", opts.deviceName);
                }
                if (opts.tensorName != null) {
                    opBuilder.setAttr("tensor_name", opts.tensorName);
                }
                if (opts.debugUrls != null) {
                    String[] debugUrlsArray = new String[opts.debugUrls.size()];
                    for (int i = 0; i < debugUrlsArray.length; ++i) {
                        debugUrlsArray[i] = (String)opts.debugUrls.get(i);
                    }
                    opBuilder.setAttr("debug_urls", debugUrlsArray);
                }
                if (opts.gatedGrpc == null) continue;
                opBuilder.setAttr("gated_grpc", opts.gatedGrpc);
            }
        }
        return new DebugNanCount(opBuilder.build());
    }

    public static Options deviceName(String deviceName) {
        return new Options().deviceName(deviceName);
    }

    public static Options tensorName(String tensorName) {
        return new Options().tensorName(tensorName);
    }

    public static Options debugUrls(List<String> debugUrls) {
        return new Options().debugUrls(debugUrls);
    }

    public static Options gatedGrpc(Boolean gatedGrpc) {
        return new Options().gatedGrpc(gatedGrpc);
    }

    public Output<TInt64> output() {
        return this.output;
    }

    @Override
    public Output<TInt64> asOutput() {
        return this.output;
    }

    private DebugNanCount(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private String deviceName;
        private String tensorName;
        private List<String> debugUrls;
        private Boolean gatedGrpc;

        public Options deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public Options tensorName(String tensorName) {
            this.tensorName = tensorName;
            return this;
        }

        public Options debugUrls(List<String> debugUrls) {
            this.debugUrls = debugUrls;
            return this;
        }

        public Options gatedGrpc(Boolean gatedGrpc) {
            this.gatedGrpc = gatedGrpc;
            return this;
        }

        private Options() {
        }
    }
}

