/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data.experimental;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class ParseExampleDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "ParseExampleDatasetV2";
    private Output<?> handle;

    public static ParseExampleDataset create(Scope scope, Operand<?> inputDataset, Operand<TInt64> numParallelCalls, Iterable<Operand<?>> denseDefaults, List<String> sparseKeys, List<String> denseKeys, List<Class<? extends TType>> sparseTypes, List<Shape> denseShapes, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, List<Class<? extends TType>> raggedValueTypes, List<Class<? extends TNumber>> raggedSplitTypes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("ParseExampleDataset"));
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(numParallelCalls.asOutput());
        opBuilder.addInputList(Operands.asOutputs(denseDefaults));
        opBuilder = scope.apply(opBuilder);
        String[] sparseKeysArray = new String[sparseKeys.size()];
        for (int i = 0; i < sparseKeysArray.length; ++i) {
            sparseKeysArray[i] = sparseKeys.get(i);
        }
        opBuilder.setAttr("sparse_keys", sparseKeysArray);
        String[] denseKeysArray = new String[denseKeys.size()];
        for (int i = 0; i < denseKeysArray.length; ++i) {
            denseKeysArray[i] = denseKeys.get(i);
        }
        opBuilder.setAttr("dense_keys", denseKeysArray);
        opBuilder.setAttr("sparse_types", Operands.toDataTypes(sparseTypes));
        Shape[] denseShapesArray = new Shape[denseShapes.size()];
        for (int i = 0; i < denseShapesArray.length; ++i) {
            denseShapesArray[i] = denseShapes.get(i);
        }
        opBuilder.setAttr("dense_shapes", denseShapesArray);
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        opBuilder.setAttr("ragged_value_types", Operands.toDataTypes(raggedValueTypes));
        opBuilder.setAttr("ragged_split_types", Operands.toDataTypes(raggedSplitTypes));
        if (options != null) {
            for (Options opts : options) {
                if (opts.deterministic != null) {
                    opBuilder.setAttr("deterministic", opts.deterministic);
                }
                if (opts.raggedKeys == null) continue;
                String[] raggedKeysArray = new String[opts.raggedKeys.size()];
                for (int i = 0; i < raggedKeysArray.length; ++i) {
                    raggedKeysArray[i] = (String)opts.raggedKeys.get(i);
                }
                opBuilder.setAttr("ragged_keys", raggedKeysArray);
            }
        }
        return new ParseExampleDataset(opBuilder.build());
    }

    public static Options deterministic(String deterministic) {
        return new Options().deterministic(deterministic);
    }

    public static Options raggedKeys(List<String> raggedKeys) {
        return new Options().raggedKeys(raggedKeys);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    private ParseExampleDataset(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private String deterministic;
        private List<String> raggedKeys;

        public Options deterministic(String deterministic) {
            this.deterministic = deterministic;
            return this;
        }

        public Options raggedKeys(List<String> raggedKeys) {
            this.raggedKeys = raggedKeys;
            return this;
        }

        private Options() {
        }
    }
}

