/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

public final class TensorArrayPack<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "TensorArrayPack";
    private Output<T> value;

    public static <T extends TType> TensorArrayPack<T> create(Scope scope, Operand<TString> handle, Operand<TFloat32> flowIn, Class<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(handle.asOutput());
        opBuilder.addInput(flowIn.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.elementShape == null) continue;
                opBuilder.setAttr("element_shape", opts.elementShape);
            }
        }
        return new TensorArrayPack<T>(opBuilder.build());
    }

    public static Options elementShape(Shape elementShape) {
        return new Options().elementShape(elementShape);
    }

    public Output<T> value() {
        return this.value;
    }

    @Override
    public Output<T> asOutput() {
        return this.value;
    }

    private TensorArrayPack(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.value = operation.output(outputIdx++);
    }

    public static class Options {
        private Shape elementShape;

        public Options elementShape(Shape elementShape) {
            this.elementShape = elementShape;
            return this;
        }

        private Options() {
        }
    }
}

