/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

public final class Split<T extends TType>
extends RawOp
implements Iterable<Operand<T>> {
    public static final String OP_NAME = "Split";
    private List<Output<T>> output;

    public static <T extends TType> Split<T> create(Scope scope, Operand<TInt32> axis, Operand<T> value, Long numSplit) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(axis.asOutput());
        opBuilder.addInput(value.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("num_split", numSplit);
        return new Split<T>(opBuilder.build());
    }

    public List<Output<T>> output() {
        return this.output;
    }

    @Override
    public Iterator<Operand<T>> iterator() {
        return this.output.iterator();
    }

    private Split(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int outputLength = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(outputIdx, outputLength));
        outputIdx += outputLength;
    }
}

