/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class Send
extends RawOp {
    public static final String OP_NAME = "Send";

    public static Send create(Scope scope, Operand<? extends TType> tensor, String tensorName, String sendDevice, Long sendDeviceIncarnation, String recvDevice, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(tensor.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("tensor_name", tensorName);
        opBuilder.setAttr("send_device", sendDevice);
        opBuilder.setAttr("send_device_incarnation", sendDeviceIncarnation);
        opBuilder.setAttr("recv_device", recvDevice);
        if (options != null) {
            for (Options opts : options) {
                if (opts.clientTerminated == null) continue;
                opBuilder.setAttr("client_terminated", opts.clientTerminated);
            }
        }
        return new Send(opBuilder.build());
    }

    public static Options clientTerminated(Boolean clientTerminated) {
        return new Options().clientTerminated(clientTerminated);
    }

    private Send(Operation operation) {
        super(operation);
    }

    public static class Options {
        private Boolean clientTerminated;

        public Options clientTerminated(Boolean clientTerminated) {
            this.clientTerminated = clientTerminated;
            return this;
        }

        private Options() {
        }
    }
}

