/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class ReverseSequence<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "ReverseSequence";
    private Output<T> output;

    public static <T extends TType> ReverseSequence<T> create(Scope scope, Operand<T> input, Operand<? extends TNumber> seqLengths, Long seqDim, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(seqLengths.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("seq_dim", seqDim);
        if (options != null) {
            for (Options opts : options) {
                if (opts.batchDim == null) continue;
                opBuilder.setAttr("batch_dim", opts.batchDim);
            }
        }
        return new ReverseSequence<T>(opBuilder.build());
    }

    public static Options batchDim(Long batchDim) {
        return new Options().batchDim(batchDim);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private ReverseSequence(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Long batchDim;

        public Options batchDim(Long batchDim) {
            this.batchDim = batchDim;
            return this;
        }

        private Options() {
        }
    }
}

