/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.buffer.nio;

import java.nio.LongBuffer;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataStorageVisitor;
import org.tensorflow.ndarray.buffer.LongDataBuffer;
import org.tensorflow.ndarray.impl.buffer.Validator;
import org.tensorflow.ndarray.impl.buffer.nio.AbstractNioDataBuffer;

final class LongNioDataBuffer
extends AbstractNioDataBuffer<Long>
implements LongDataBuffer {
    private LongBuffer buf;

    @Override
    public long getLong(long index) {
        return this.buf.get((int)index);
    }

    @Override
    public LongDataBuffer setLong(long value, long index) {
        this.buf.put((int)index, value);
        return this;
    }

    @Override
    public LongDataBuffer read(long[] dst, int offset, int length) {
        this.buf.duplicate().get(dst, offset, length);
        return this;
    }

    @Override
    public LongDataBuffer write(long[] src, int offset, int length) {
        this.buf.duplicate().put(src, offset, length);
        return this;
    }

    @Override
    public LongDataBuffer copyTo(final DataBuffer<Long> dst, final long size) {
        Validator.copyToArgs(this, dst, size);
        return dst.accept(new DataStorageVisitor<LongDataBuffer>(){

            @Override
            public LongDataBuffer visit(LongBuffer buffer) {
                buffer.duplicate().put((LongBuffer)LongNioDataBuffer.this.buf.duplicate().limit((int)size));
                return LongNioDataBuffer.this;
            }

            @Override
            public LongDataBuffer fallback() {
                if (dst instanceof LongDataBuffer) {
                    LongDataBuffer longDst = (LongDataBuffer)dst;
                    for (long idx = 0L; idx < size; ++idx) {
                        longDst.setLong(LongNioDataBuffer.this.getLong(idx), idx);
                    }
                    return LongNioDataBuffer.this;
                }
                return (LongDataBuffer)LongNioDataBuffer.this.slowCopyTo(dst, size);
            }
        });
    }

    @Override
    public LongDataBuffer offset(long index) {
        Validator.offsetArgs(this, index);
        return new LongNioDataBuffer(((LongBuffer)this.buf.duplicate().position((int)index)).slice());
    }

    @Override
    public LongDataBuffer narrow(long size) {
        Validator.narrowArgs(this, size);
        return new LongNioDataBuffer(((LongBuffer)this.buf.duplicate().limit((int)size)).slice());
    }

    @Override
    public LongDataBuffer slice(long index, long size) {
        Validator.sliceArgs(this, index, size);
        LongBuffer sliceBuf = this.buf.duplicate();
        sliceBuf.position((int)index);
        sliceBuf.limit((int)index + (int)size);
        return new LongNioDataBuffer(sliceBuf.slice());
    }

    @Override
    public <R> R accept(DataStorageVisitor<R> visitor) {
        return visitor.visit(this.buf);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongDataBuffer)) {
            return super.equals(obj);
        }
        final LongDataBuffer other = (LongDataBuffer)obj;
        if (this.size() != other.size()) {
            return false;
        }
        return other.accept(new DataStorageVisitor<Boolean>(){

            @Override
            public Boolean visit(LongBuffer buffer) {
                return LongNioDataBuffer.this.buf.equals(buffer);
            }

            @Override
            public Boolean fallback() {
                int idx = 0;
                while ((long)idx < LongNioDataBuffer.this.size()) {
                    if (other.getLong(idx) != LongNioDataBuffer.this.getLong(idx)) {
                        return false;
                    }
                    ++idx;
                }
                return true;
            }
        });
    }

    @Override
    LongBuffer buf() {
        return this.buf;
    }

    LongNioDataBuffer(LongBuffer buf) {
        this.buf = buf;
    }
}

