/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

public final class RebatchDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "RebatchDataset";
    private Output<?> handle;

    public static RebatchDataset create(Scope scope, Operand<?> inputDataset, Operand<TInt64> numReplicas, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(numReplicas.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.useFallback == null) continue;
                opBuilder.setAttr("use_fallback", opts.useFallback);
            }
        }
        return new RebatchDataset(opBuilder.build());
    }

    public static Options useFallback(Boolean useFallback) {
        return new Options().useFallback(useFallback);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    private RebatchDataset(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean useFallback;

        public Options useFallback(Boolean useFallback) {
            this.useFallback = useFallback;
            return this;
        }

        private Options() {
        }
    }
}

