/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class ResourceStridedSliceAssign
extends RawOp {
    public static final String OP_NAME = "ResourceStridedSliceAssign";

    public static <T extends TNumber> ResourceStridedSliceAssign create(Scope scope, Operand<?> ref, Operand<T> begin, Operand<T> end, Operand<T> strides, Operand<? extends TType> value, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(ref.asOutput());
        opBuilder.addInput(begin.asOutput());
        opBuilder.addInput(end.asOutput());
        opBuilder.addInput(strides.asOutput());
        opBuilder.addInput(value.asOutput());
        opBuilder = scope.apply(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.beginMask != null) {
                    opBuilder.setAttr("begin_mask", opts.beginMask);
                }
                if (opts.endMask != null) {
                    opBuilder.setAttr("end_mask", opts.endMask);
                }
                if (opts.ellipsisMask != null) {
                    opBuilder.setAttr("ellipsis_mask", opts.ellipsisMask);
                }
                if (opts.newAxisMask != null) {
                    opBuilder.setAttr("new_axis_mask", opts.newAxisMask);
                }
                if (opts.shrinkAxisMask == null) continue;
                opBuilder.setAttr("shrink_axis_mask", opts.shrinkAxisMask);
            }
        }
        return new ResourceStridedSliceAssign(opBuilder.build());
    }

    public static Options beginMask(Long beginMask) {
        return new Options().beginMask(beginMask);
    }

    public static Options endMask(Long endMask) {
        return new Options().endMask(endMask);
    }

    public static Options ellipsisMask(Long ellipsisMask) {
        return new Options().ellipsisMask(ellipsisMask);
    }

    public static Options newAxisMask(Long newAxisMask) {
        return new Options().newAxisMask(newAxisMask);
    }

    public static Options shrinkAxisMask(Long shrinkAxisMask) {
        return new Options().shrinkAxisMask(shrinkAxisMask);
    }

    private ResourceStridedSliceAssign(Operation operation) {
        super(operation);
    }

    public static class Options {
        private Long beginMask;
        private Long endMask;
        private Long ellipsisMask;
        private Long newAxisMask;
        private Long shrinkAxisMask;

        public Options beginMask(Long beginMask) {
            this.beginMask = beginMask;
            return this;
        }

        public Options endMask(Long endMask) {
            this.endMask = endMask;
            return this;
        }

        public Options ellipsisMask(Long ellipsisMask) {
            this.ellipsisMask = ellipsisMask;
            return this;
        }

        public Options newAxisMask(Long newAxisMask) {
            this.newAxisMask = newAxisMask;
            return this;
        }

        public Options shrinkAxisMask(Long shrinkAxisMask) {
            this.shrinkAxisMask = shrinkAxisMask;
            return this;
        }

        private Options() {
        }
    }
}

