/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.buffer.raw;

import java.nio.FloatBuffer;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataStorageVisitor;
import org.tensorflow.ndarray.buffer.FloatDataBuffer;
import org.tensorflow.ndarray.impl.buffer.Validator;
import org.tensorflow.ndarray.impl.buffer.raw.AbstractRawDataBuffer;
import org.tensorflow.ndarray.impl.buffer.raw.UnsafeMemoryHandle;

final class FloatRawDataBuffer
extends AbstractRawDataBuffer<Float, FloatDataBuffer>
implements FloatDataBuffer {
    @Override
    public float getFloat(long index) {
        Validator.getArgs(this, index);
        return this.memory.getFloat(index);
    }

    @Override
    public FloatDataBuffer setFloat(float value, long index) {
        Validator.setArgs(this, index);
        this.memory.setFloat(value, index);
        return this;
    }

    @Override
    public FloatDataBuffer read(float[] dst) {
        return (FloatDataBuffer)this.read(dst, dst.length);
    }

    @Override
    public FloatDataBuffer read(float[] dst, int offset, int length) {
        return (FloatDataBuffer)this.read(dst, dst.length, offset, length);
    }

    @Override
    public FloatDataBuffer write(float[] src) {
        return (FloatDataBuffer)this.write(src, src.length);
    }

    @Override
    public FloatDataBuffer write(float[] src, int offset, int length) {
        return (FloatDataBuffer)this.write(src, src.length, offset, length);
    }

    @Override
    public FloatDataBuffer copyTo(final DataBuffer<Float> dst, final long size) {
        Validator.copyToArgs(this, dst, size);
        return dst.accept(new DataStorageVisitor<FloatDataBuffer>(){

            @Override
            public FloatDataBuffer visit(FloatBuffer buffer) {
                if (buffer.hasArray()) {
                    FloatRawDataBuffer.this.memory.copyTo(UnsafeMemoryHandle.fromArray(buffer.array(), buffer.position(), buffer.limit()), size);
                } else if (FloatRawDataBuffer.this.memory.isArray()) {
                    buffer.put(FloatRawDataBuffer.this.memory.toArrayFloatBuffer());
                } else {
                    FloatRawDataBuffer.this.slowCopyTo(dst, size);
                }
                return FloatRawDataBuffer.this;
            }

            @Override
            public FloatDataBuffer visit(long address, long length, long scale) {
                FloatRawDataBuffer.this.memory.copyTo(UnsafeMemoryHandle.fromAddress(address, length, scale), size);
                return FloatRawDataBuffer.this;
            }

            @Override
            public FloatDataBuffer fallback() {
                if (dst instanceof FloatDataBuffer) {
                    FloatDataBuffer floatDst = (FloatDataBuffer)dst;
                    for (long idx = 0L; idx < size; ++idx) {
                        floatDst.setFloat(FloatRawDataBuffer.this.getFloat(idx), idx);
                    }
                    return FloatRawDataBuffer.this;
                }
                return (FloatDataBuffer)FloatRawDataBuffer.this.slowCopyTo(dst, size);
            }
        });
    }

    @Override
    public <R> R accept(DataStorageVisitor<R> visitor) {
        if (this.memory.isArray()) {
            return visitor.visit(this.memory.toArrayFloatBuffer());
        }
        return visitor.visit(this.memory.byteOffset, this.memory.byteSize, this.memory.scale);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FloatDataBuffer)) {
            return super.equals(obj);
        }
        final FloatDataBuffer other = (FloatDataBuffer)obj;
        if (this.size() != other.size()) {
            return false;
        }
        return other.accept(new DataStorageVisitor<Boolean>(){

            @Override
            public Boolean visit(FloatBuffer buffer) {
                if (FloatRawDataBuffer.this.memory.isArray()) {
                    return buffer.equals(FloatRawDataBuffer.this.memory.toArrayFloatBuffer());
                }
                return this.fallback();
            }

            @Override
            public Boolean fallback() {
                for (long idx = 0L; idx < FloatRawDataBuffer.this.size(); ++idx) {
                    if (other.getFloat(idx) == FloatRawDataBuffer.this.getFloat(idx)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    protected FloatDataBuffer instantiate(UnsafeMemoryHandle memory) {
        return new FloatRawDataBuffer(memory, this.readOnly);
    }

    FloatRawDataBuffer(UnsafeMemoryHandle memory, boolean readOnly) {
        super(memory, readOnly);
    }
}

