/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.buffer.nio;

import java.nio.IntBuffer;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataStorageVisitor;
import org.tensorflow.ndarray.buffer.IntDataBuffer;
import org.tensorflow.ndarray.impl.buffer.Validator;
import org.tensorflow.ndarray.impl.buffer.nio.AbstractNioDataBuffer;

final class IntNioDataBuffer
extends AbstractNioDataBuffer<Integer>
implements IntDataBuffer {
    private IntBuffer buf;

    @Override
    public int getInt(long index) {
        return this.buf.get((int)index);
    }

    @Override
    public IntDataBuffer setInt(int value, long index) {
        this.buf.put((int)index, value);
        return this;
    }

    @Override
    public IntDataBuffer read(int[] dst, int offset, int length) {
        this.buf.duplicate().get(dst, offset, length);
        return this;
    }

    @Override
    public IntDataBuffer write(int[] src, int offset, int length) {
        this.buf.duplicate().put(src, offset, length);
        return this;
    }

    @Override
    public IntDataBuffer copyTo(final DataBuffer<Integer> dst, final long size) {
        Validator.copyToArgs(this, dst, size);
        return dst.accept(new DataStorageVisitor<IntDataBuffer>(){

            @Override
            public IntDataBuffer visit(IntBuffer buffer) {
                buffer.duplicate().put((IntBuffer)IntNioDataBuffer.this.buf.duplicate().limit((int)size));
                return IntNioDataBuffer.this;
            }

            @Override
            public IntDataBuffer fallback() {
                if (dst instanceof IntDataBuffer) {
                    IntDataBuffer intDst = (IntDataBuffer)dst;
                    for (long idx = 0L; idx < size; ++idx) {
                        intDst.setInt(IntNioDataBuffer.this.getInt(idx), idx);
                    }
                    return IntNioDataBuffer.this;
                }
                return (IntDataBuffer)IntNioDataBuffer.this.slowCopyTo(dst, size);
            }
        });
    }

    @Override
    public IntDataBuffer offset(long index) {
        Validator.offsetArgs(this, index);
        return new IntNioDataBuffer(((IntBuffer)this.buf.duplicate().position((int)index)).slice());
    }

    @Override
    public IntDataBuffer narrow(long size) {
        Validator.narrowArgs(this, size);
        return new IntNioDataBuffer(((IntBuffer)this.buf.duplicate().limit((int)size)).slice());
    }

    @Override
    public IntDataBuffer slice(long index, long size) {
        Validator.sliceArgs(this, index, size);
        IntBuffer sliceBuf = this.buf.duplicate();
        sliceBuf.position((int)index);
        sliceBuf.limit((int)index + (int)size);
        return new IntNioDataBuffer(sliceBuf.slice());
    }

    @Override
    public <R> R accept(DataStorageVisitor<R> visitor) {
        return visitor.visit(this.buf);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntDataBuffer)) {
            return super.equals(obj);
        }
        final IntDataBuffer other = (IntDataBuffer)obj;
        if (this.size() != other.size()) {
            return false;
        }
        return other.accept(new DataStorageVisitor<Boolean>(){

            @Override
            public Boolean visit(IntBuffer buffer) {
                return IntNioDataBuffer.this.buf.equals(buffer);
            }

            @Override
            public Boolean fallback() {
                int idx = 0;
                while ((long)idx < IntNioDataBuffer.this.size()) {
                    if (other.getInt(idx) != IntNioDataBuffer.this.getInt(idx)) {
                        return false;
                    }
                    ++idx;
                }
                return true;
            }
        });
    }

    @Override
    IntBuffer buf() {
        return this.buf;
    }

    IntNioDataBuffer(IntBuffer buf) {
        this.buf = buf;
    }
}

