/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.bytedeco.javacpp.BooleanPointer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.PointerScope;
import org.bytedeco.javacpp.SizeTPointer;
import org.tensorflow.EagerOperation;
import org.tensorflow.EagerSession;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Tensor;
import org.tensorflow.internal.c_api.TFE_Context;
import org.tensorflow.internal.c_api.TFE_Op;
import org.tensorflow.internal.c_api.TFE_TensorHandle;
import org.tensorflow.internal.c_api.TF_Status;
import org.tensorflow.internal.c_api.TF_Tensor;
import org.tensorflow.internal.c_api.global.tensorflow;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.proto.framework.DataType;

final class EagerOperationBuilder
implements OperationBuilder {
    private TFE_Op opHandle;
    private final EagerSession session;
    private final String type;
    private final String name;
    private static final int MAX_OUTPUTS_PER_OP = 1000;

    EagerOperationBuilder(EagerSession session, String type, String name) {
        this.session = session;
        this.type = type;
        this.name = name;
        this.opHandle = EagerOperationBuilder.allocate(session, type);
    }

    @Override
    public EagerOperation build() {
        TFE_TensorHandle[] tensorHandles = EagerOperationBuilder.execute(this.opHandle, this.session);
        return new EagerOperation(this.session, this.opHandle, tensorHandles, this.type, this.name);
    }

    @Override
    public EagerOperationBuilder addInput(Output<?> input) {
        this.session.checkInput(input);
        EagerOperationBuilder.addInput(this.opHandle, (TFE_TensorHandle)input.getUnsafeNativeHandle());
        return this;
    }

    @Override
    public EagerOperationBuilder addInputList(Output<?>[] inputs) {
        TFE_TensorHandle[] inputHandles = new TFE_TensorHandle[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            this.session.checkInput(inputs[i]);
            inputHandles[i] = (TFE_TensorHandle)inputs[i].getUnsafeNativeHandle();
        }
        EagerOperationBuilder.addInputList(this.opHandle, inputHandles);
        return this;
    }

    @Override
    public OperationBuilder addControlInput(Operation control) {
        return this;
    }

    @Override
    public EagerOperationBuilder setDevice(String device) {
        EagerOperationBuilder.setDevice(this.opHandle, device);
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, String value) {
        return this.setAttr(name, value.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public EagerOperationBuilder setAttr(String name, String[] values) {
        Charset utf8 = StandardCharsets.UTF_8;
        byte[][] objects = new byte[values.length][];
        for (int i = 0; i < values.length; ++i) {
            objects[i] = values[i].getBytes(utf8);
        }
        EagerOperationBuilder.setAttrStringList(this.opHandle, name, objects);
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, byte[] values) {
        EagerOperationBuilder.setAttrString(this.opHandle, name, values);
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, long value) {
        EagerOperationBuilder.setAttrInt(this.opHandle, name, value);
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, long[] values) {
        EagerOperationBuilder.setAttrIntList(this.opHandle, name, values);
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, float value) {
        EagerOperationBuilder.setAttrFloat(this.opHandle, name, value);
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, float[] values) {
        EagerOperationBuilder.setAttrFloatList(this.opHandle, name, values);
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, boolean value) {
        EagerOperationBuilder.setAttrBool(this.opHandle, name, value);
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, boolean[] values) {
        EagerOperationBuilder.setAttrBoolList(this.opHandle, name, values);
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, DataType value) {
        EagerOperationBuilder.setAttrType(this.opHandle, name, value.getNumber());
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, DataType[] values) {
        int[] c = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            c[i] = values[i].getNumber();
        }
        EagerOperationBuilder.setAttrTypeList(this.opHandle, name, c);
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, Tensor value) {
        EagerOperationBuilder.setAttrTensor(this.opHandle, name, value.asRawTensor().nativeHandle());
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, Tensor[] values) {
        throw new UnsupportedOperationException("Tensor list attributes are not supported in eager mode");
    }

    @Override
    public EagerOperationBuilder setAttr(String name, Shape value) {
        EagerOperationBuilder.setAttrShape(this.opHandle, name, value.asArray(), value.numDimensions());
        return this;
    }

    @Override
    public EagerOperationBuilder setAttr(String name, Shape[] values) {
        int[] numDimensions = new int[values.length];
        int totalNumDimensions = 0;
        for (int idx = 0; idx < values.length; ++idx) {
            int n;
            numDimensions[idx] = n = values[idx].numDimensions();
            if (n <= 0) continue;
            totalNumDimensions += n;
        }
        long[] shapes = new long[totalNumDimensions];
        int shapeIdx = 0;
        for (Shape shape : values) {
            if (shape.numDimensions() <= 0) continue;
            for (long dim : shape.asArray()) {
                shapes[shapeIdx++] = dim;
            }
        }
        EagerOperationBuilder.setAttrShapeList(this.opHandle, name, shapes, numDimensions);
        return this;
    }

    private static void requireOp(TFE_Op handle) {
        if (handle == null || handle.isNull()) {
            throw new IllegalStateException("Operation has already been built");
        }
    }

    private static void requireContext(TFE_Context handle) {
        if (handle == null || handle.isNull()) {
            throw new IllegalStateException("Context has been deleted");
        }
    }

    private static void requireTensor(TF_Tensor handle) {
        if (handle == null || handle.isNull()) {
            throw new IllegalStateException("close() has been called on the Tensor");
        }
    }

    private static void requireTensorHandle(TFE_TensorHandle handle) {
        if (handle == null || handle.isNull()) {
            throw new IllegalStateException("Tensor handle has been deleted");
        }
    }

    private static TFE_Op allocate(EagerSession session, String type) {
        EagerOperationBuilder.requireContext(session.nativeHandle());
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Status status = TF_Status.newStatus();
            TFE_Op op = TFE_Op.newOp(session.nativeHandle(), type, status);
            status.throwExceptionIfNotOK();
            session.attach(op);
            TFE_Op tFE_Op = op;
            return tFE_Op;
        }
    }

    private static TFE_TensorHandle[] execute(TFE_Op opHandle, EagerSession session) {
        EagerOperationBuilder.requireOp(opHandle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            IntPointer numRetvals = new IntPointer(1L).put(1000);
            PointerPointer retvals = new PointerPointer(1000L);
            TF_Status status = TF_Status.newStatus();
            tensorflow.TFE_Execute(opHandle, retvals, numRetvals, status);
            status.throwExceptionIfNotOK();
            TFE_TensorHandle[] rethandles = new TFE_TensorHandle[numRetvals.get()];
            for (int i = 0; i < rethandles.length; ++i) {
                rethandles[i] = ((TFE_TensorHandle)retvals.get(TFE_TensorHandle.class, (long)i)).withDeallocator();
                session.attach(rethandles[i]);
            }
            TFE_TensorHandle[] tFE_TensorHandleArray = rethandles;
            return tFE_TensorHandleArray;
        }
    }

    private static void addInput(TFE_Op opHandle, TFE_TensorHandle tensorHandle) {
        EagerOperationBuilder.requireOp(opHandle);
        EagerOperationBuilder.requireTensorHandle(tensorHandle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Status status = TF_Status.newStatus();
            tensorflow.TFE_OpAddInput(opHandle, tensorHandle, status);
            status.throwExceptionIfNotOK();
        }
    }

    private static void addInputList(TFE_Op opHandle, TFE_TensorHandle[] tensorHandles) {
        EagerOperationBuilder.requireOp(opHandle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            PointerPointer tensorPointers = new PointerPointer((long)tensorHandles.length);
            for (int i = 0; i < tensorHandles.length; ++i) {
                EagerOperationBuilder.requireTensorHandle(tensorHandles[i]);
                tensorPointers.put((long)i, (Pointer)tensorHandles[i]);
            }
            TF_Status status = TF_Status.newStatus();
            tensorflow.TFE_OpAddInputList(opHandle, tensorPointers, tensorHandles.length, status);
            status.throwExceptionIfNotOK();
        }
    }

    private static void setDevice(TFE_Op opHandle, String device) {
        EagerOperationBuilder.requireOp(opHandle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Status status = TF_Status.newStatus();
            tensorflow.TFE_OpSetDevice(opHandle, device, status);
            status.throwExceptionIfNotOK();
        }
    }

    private static void setAttrString(TFE_Op opHandle, String name, byte[] value) {
        EagerOperationBuilder.requireOp(opHandle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            tensorflow.TFE_OpSetAttrString(opHandle, name, (Pointer)new BytePointer(value), (long)value.length);
        }
    }

    private static void setAttrStringList(TFE_Op opHandle, String name, byte[][] value) {
        EagerOperationBuilder.requireOp(opHandle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            PointerPointer valuePointers = new PointerPointer((long)value.length);
            SizeTPointer lengths = new SizeTPointer((long)value.length);
            for (int i = 0; i < value.length; ++i) {
                valuePointers.put((long)i, (Pointer)new BytePointer(value[i]));
                lengths.put((long)i, (long)value[i].length);
            }
            tensorflow.TFE_OpSetAttrStringList(opHandle, name, (Pointer)valuePointers, lengths, value.length);
        }
    }

    private static void setAttrInt(TFE_Op opHandle, String name, long value) {
        EagerOperationBuilder.requireOp(opHandle);
        tensorflow.TFE_OpSetAttrInt(opHandle, name, value);
    }

    private static void setAttrIntList(TFE_Op opHandle, String name, long[] values) {
        EagerOperationBuilder.requireOp(opHandle);
        tensorflow.TFE_OpSetAttrIntList(opHandle, name, values, values.length);
    }

    private static void setAttrFloat(TFE_Op opHandle, String name, float value) {
        EagerOperationBuilder.requireOp(opHandle);
        tensorflow.TFE_OpSetAttrFloat(opHandle, name, value);
    }

    private static void setAttrFloatList(TFE_Op opHandle, String name, float[] values) {
        EagerOperationBuilder.requireOp(opHandle);
        tensorflow.TFE_OpSetAttrFloatList(opHandle, name, values, values.length);
    }

    private static void setAttrBool(TFE_Op opHandle, String name, boolean value) {
        EagerOperationBuilder.requireOp(opHandle);
        tensorflow.TFE_OpSetAttrBool(opHandle, name, (byte)(value ? 1 : 0));
    }

    private static void setAttrBoolList(TFE_Op opHandle, String name, boolean[] values) {
        EagerOperationBuilder.requireOp(opHandle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            tensorflow.TFE_OpSetAttrBoolList(opHandle, name, new BytePointer((Pointer)new BooleanPointer(values)), values.length);
        }
    }

    private static void setAttrType(TFE_Op opHandle, String name, int type) {
        EagerOperationBuilder.requireOp(opHandle);
        tensorflow.TFE_OpSetAttrType(opHandle, name, type);
    }

    private static void setAttrTypeList(TFE_Op opHandle, String name, int[] types) {
        EagerOperationBuilder.requireOp(opHandle);
        tensorflow.TFE_OpSetAttrTypeList(opHandle, name, types, types.length);
    }

    private static void setAttrTensor(TFE_Op opHandle, String name, TF_Tensor tensorHandle) {
        EagerOperationBuilder.requireOp(opHandle);
        EagerOperationBuilder.requireTensor(tensorHandle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Status status = TF_Status.newStatus();
            tensorflow.TFE_OpSetAttrTensor(opHandle, name, tensorHandle, status);
            status.throwExceptionIfNotOK();
        }
    }

    private static void setAttrShape(TFE_Op opHandle, String name, long[] shape, int numDims) {
        EagerOperationBuilder.requireOp(opHandle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Status status = TF_Status.newStatus();
            tensorflow.TFE_OpSetAttrShape(opHandle, name, shape, numDims, status);
            status.throwExceptionIfNotOK();
        }
    }

    private static void setAttrShapeList(TFE_Op opHandle, String name, long[] shapes, int[] numDims) {
        EagerOperationBuilder.requireOp(opHandle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            LongPointer shapesPointer = new LongPointer(shapes);
            PointerPointer shapesPointers = new PointerPointer((long)numDims.length);
            for (int i = 0; i < numDims.length; ++i) {
                shapesPointers.put((long)i, (Pointer)shapesPointer);
                shapesPointer.position(shapesPointer.position() + (long)(numDims[i] * 8));
            }
            TF_Status status = TF_Status.newStatus();
            tensorflow.TFE_OpSetAttrShapeList(opHandle, new BytePointer(name), shapesPointers, new IntPointer(numDims), numDims.length, status);
        }
    }
}

