/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

public final class SparseToSparseSetOperation<T extends TType>
extends RawOp {
    public static final String OP_NAME = "SparseToSparseSetOperation";
    private Output<TInt64> resultIndices;
    private Output<T> resultValues;
    private Output<TInt64> resultShape;

    public static <T extends TType> SparseToSparseSetOperation<T> create(Scope scope, Operand<TInt64> set1Indices, Operand<T> set1Values, Operand<TInt64> set1Shape, Operand<TInt64> set2Indices, Operand<T> set2Values, Operand<TInt64> set2Shape, String setOperation, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(set1Indices.asOutput());
        opBuilder.addInput(set1Values.asOutput());
        opBuilder.addInput(set1Shape.asOutput());
        opBuilder.addInput(set2Indices.asOutput());
        opBuilder.addInput(set2Values.asOutput());
        opBuilder.addInput(set2Shape.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("set_operation", setOperation);
        if (options != null) {
            for (Options opts : options) {
                if (opts.validateIndices == null) continue;
                opBuilder.setAttr("validate_indices", opts.validateIndices);
            }
        }
        return new SparseToSparseSetOperation<T>(opBuilder.build());
    }

    public static Options validateIndices(Boolean validateIndices) {
        return new Options().validateIndices(validateIndices);
    }

    public Output<TInt64> resultIndices() {
        return this.resultIndices;
    }

    public Output<T> resultValues() {
        return this.resultValues;
    }

    public Output<TInt64> resultShape() {
        return this.resultShape;
    }

    private SparseToSparseSetOperation(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.resultIndices = operation.output(outputIdx++);
        this.resultValues = operation.output(outputIdx++);
        this.resultShape = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean validateIndices;

        public Options validateIndices(Boolean validateIndices) {
            this.validateIndices = validateIndices;
            return this;
        }

        private Options() {
        }
    }
}

